//
//  GMViewController.m
//  GMPhobos
//
//  Created by licong on 01/27/2016.
//  Copyright (c) 2016 licong. All rights reserved.
//

#import "GMViewController.h"
#import <GMPhobos/Phobos.h>
#import <GMCache/GMCache.h>
//@import GMCache;
@import GMPhobos.PhobosUtil;
@import GMPhobos.Phobos;
#define PhobosCacheKey @"PhobosCacheKey"

NSString      *const MockAppName      = @"gengmei_test";
NSString      *const MockChannelId    = @"AppStore";
NSString      *const MockEventId      = @"eventId";
NSString      *const MockUserId       = @"1";
NSString      *const MockCityId       = @"beijing";

@interface GMViewController ()

@end

@implementation GMViewController

- (void)viewDidLoad
{
    [super viewDidLoad];

#ifdef POD_CONFIGURATION_APP_STORE
    NSString *url = @"http://log.gmei.com/log/collect";
#else
    NSString *url = @"http://log.test.gengmei.cc/log/collect";
#endif
    [GMCache removeObjectAtDocumentPathWithkey:PhobosCacheKey];
    Phobos *phobos = [Phobos clientWithAppName:MockAppName channelId:MockChannelId];
    phobos.serverAPI = url;
    [phobos setLogEnabled:NO]; // 调试打Log模式，看情况开启
    phobos.signingType = PhobosSigningTypeDebug;
    phobos.userId = @"";
    [Phobos setSharedClient:phobos];
    
    NSString *inDate = [PhobosUtil currentTime];
    NSMutableDictionary *dict = [[NSMutableDictionary alloc] init];
    [dict setObject:[PhobosUtil currentTime] forKey:@"out"];
    [dict setObject:inDate forKey:@"in"];
    [dict setObject:@"test" forKey:@"page_name"];
    [dict setObject:@"" forKey:@"business_id"];
    [dict setObject:@"" forKey:@"referrer"];
    [dict setObject:@(0) forKey:@"fake"];
    [dict setObject:@"" forKey:@"referrer_id"];
    [dict setObject:@"" forKey:@"extra_param"];
    [dict setObject:@"" forKey:@"referrer_tab_name"];
    [dict setObject:@(0) forKey:@"is_push"];
    [Phobos track:@"page_view" attributes:dict];
    NSArray *array = [GMCache fetchObjectAtDocumentPathWithkey:PhobosCacheKey];
    
    [Phobos track:@"page_view" attributes:dict];
    array = [GMCache fetchObjectAtDocumentPathWithkey:PhobosCacheKey];
    
    [dict setObject:[PhobosUtil currentTime] forKey:@"in"];
    [dict setObject:[PhobosUtil currentTime] forKey:@"out"];
    [Phobos track:@"page_view" attributes:dict];
    array = [GMCache fetchObjectAtDocumentPathWithkey:PhobosCacheKey];
    
    [Phobos track:@"test" attributes:dict];
    array = [GMCache fetchObjectAtDocumentPathWithkey:PhobosCacheKey];
    
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
