//
//  PhobosUtil.h
//  Phobos工具类
//
//  Created by Thierry on 16/2/15.
//
//

#import <Foundation/Foundation.h>

typedef void (^SendDataSuccessBlock)(NSInteger code);

@interface PhobosUtil : NSObject

/**
 *  @brief 压缩待上传的数据。经过测试，50条数据压缩大概6毫秒，所以不要放在异步线程中处理
 *
 *  @param originData 压缩前的数据
 *
 *  @return 压缩后的数据
 *
 *  @since 0.0.1
 */
+ (NSData *)compressData:(NSData *)originData;

/**
 *  @brief 上传数据
 *
 *  @param data,success
 *
 *  @since 0.0.1
 */
+ (void)sendData:(NSData *)data success:(SendDataSuccessBlock)success;

+ (NSString *)currentTime;
+ (NSString *)getAppVersion;
+ (BOOL)isNonEmpty:(NSString *)string;
+ (NSData *)encodeJSON:(id)obj;
+ (NSString *)deviceId;
/**
 * 获取IP地址
 */
+ (NSString *)getIPAddress:(BOOL)preferIPv4;

/**
 * 获取cup指令集
 */
+ (NSString *)currentDeviceCPUType;

/***
 * CPU总数目
 **/
+ (NSString *)currentDeviceCPUCount;

/***
 * 网卡地址
 **/
+ (NSString *)getMacAddress;

/**
 * 获取运营商信息
 */
+ (NSString *)getTelephonyInfo;

/**
 * 内存大小，单位：兆
 */
+ (NSString *)getTotalMemorySize;

/**
 * 获取手机运行时间，从开机到现在
 */
+ (NSString *)deviceRunTime;





@end
