//
//  UIViewController+Tracker.m
//  Gengmei
//
//  Created by Mikasa on 2019/6/25.
//  Copyright © 2019 更美互动信息科技有限公司. All rights reserved.
//

#import "UIViewController+Tracker.h"
#import "GMExposureManager.h"
#import "NSObject+Swizzle.h"
#import <objc/runtime.h>

@implementation UIViewController (Tracker)

+ (void)load {
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
         [self startViewPageExpoTracker];
    });
}

+ (void)startViewPageExpoTracker {
    
    [self swizzleInstanceMethod:@selector(viewDidLoad) withSelector:@selector(swizzle_viewDidLoad)];
    [self swizzleInstanceMethod:@selector(viewDidAppear:) withSelector:@selector(swizzle_viewDidAppear:)];
    [self swizzleInstanceMethod:@selector(viewDidDisappear:) withSelector:@selector(swizzle_viewDidDisappear:)];
    
}

- (void)swizzle_viewDidLoad {
    
    [self swizzle_viewDidLoad];
    if (self.needExpo) {
        self.view.pageCtrl = self;
    }
}

- (void)swizzle_viewDidAppear:(BOOL)animated {
    
    [self swizzle_viewDidAppear:animated];
    if (self.needExpo) {
        self.view.pageCtrl = self;
        [GMExposureManager fetchViewForVisibleState:self.view trackerType:GMViewTrackerTypeUIViewDidAppear recursive:YES];
        if (self.needImmediatelySend) {
            [GMExposureManager.sharedManager uploadExposureDataForPage:self];
        }
    }
}

- (void)swizzle_viewDidDisappear:(BOOL)animated {
    
    if (self.needExpo) {
        [[GMExposureManager sharedManager] endExpoTrcakerForPageCtrl:self];
    }
    [self swizzle_viewDidDisappear:animated];
}

#pragma mark - UIScrollViewDelegate
- (void)scrollViewWillBeginDragging:(UIScrollView *)scrollView {
    
    if (scrollView.pageCtrl.needExpo) {
        scrollView.preContentOffsetY = scrollView.contentOffset.y;
    }
    
}
- (void)scrollViewDidEndDragging:(UIScrollView *)scrollView willDecelerate:(BOOL)decelerate {
    
    if (scrollView.pageCtrl.needExpo && !decelerate) {
        [scrollView calculateUpOrDownTimes];
        [GMExposureManager fetchViewForVisibleState:scrollView trackerType:GMViewTrackerTypeUIScrollDragging recursive:YES];
        if (self.needImmediatelySend) {
            [GMExposureManager.sharedManager endExpoTrcakerForPageCtrl:self];
        }
    }
    //NSLog(@"%@:%zd--%zd",scrollView.pageCtrl,scrollView.pageCtrl.down_slide_times,scrollView.pageCtrl.up_slide_times);
}

- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView {
    
    if (scrollView.pageCtrl.needExpo) {
        
        [scrollView calculateUpOrDownTimes];
        [GMExposureManager fetchViewForVisibleState:scrollView trackerType:GMViewTrackerTypeUIScrollDragging recursive:YES];
        if (self.needImmediatelySend) {
            [GMExposureManager.sharedManager endExpoTrcakerForPageCtrl:self];
        }
    }
    
}

#pragma mark - GMPageExposureProtocol
- (void)setNeedImmediatelySend:(BOOL)needImmediatelySend {
    objc_setAssociatedObject(self, @selector(needImmediatelySend), @(needImmediatelySend), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (BOOL)needImmediatelySend {
    return [objc_getAssociatedObject(self, @selector(needImmediatelySend)) boolValue];
}

- (void)setNeedExpo:(BOOL)needExpo {
    objc_setAssociatedObject(self, @selector(needExpo), @(needExpo), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (BOOL)needExpo {
    return [objc_getAssociatedObject(self, @selector(needExpo)) boolValue];
}

- (void)setUp_slide_times:(NSInteger)up_slide_times {
    objc_setAssociatedObject(self, @selector(up_slide_times), @(up_slide_times), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (NSInteger)up_slide_times {
    return [objc_getAssociatedObject(self, @selector(up_slide_times)) integerValue];
}

- (void)setDown_slide_times:(NSInteger)down_slide_times {
    objc_setAssociatedObject(self, @selector(down_slide_times), @(down_slide_times), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
    
}

- (NSInteger)down_slide_times {
    return [objc_getAssociatedObject(self, @selector(down_slide_times)) integerValue];
}

- (void)setUp_loading_times:(NSInteger)up_loading_times {
    objc_setAssociatedObject(self, @selector(up_loading_times), @(up_loading_times), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (NSInteger)up_loading_times {
    return [objc_getAssociatedObject(self, @selector(up_loading_times)) integerValue];
}

- (void)setDown_loading_times:(NSInteger)down_loading_times {
    objc_setAssociatedObject(self, @selector(down_loading_times), @(down_loading_times), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
    
}

- (NSInteger)down_loading_times {
    return [objc_getAssociatedObject(self, @selector(down_loading_times)) integerValue];
}

- (void)setExtra_param:(NSDictionary *)extra_param {
    objc_setAssociatedObject(self, @selector(extra_param), extra_param, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (NSDictionary *)extra_param {
    return objc_getAssociatedObject(self, @selector(extra_param));
}
@end
