//
//  PhobosSendManager.m
//  GMPhobos
//
//  Created by Locus on 2020/3/3.
//

#import "PhobosSendManager.h"
#import <GMCache/GMCache.h>
#import <MJExtension/MJExtension.h>
#import "PhobosConfig.h"
#import "Phobos.h"
#import "PhobosUtil.h"
#import "GMExposureManager.h"

@implementation PhobosSendManager

+ (void)initialize {
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        // 处理非灰情况下未发送完成数据
        [self disposeOldData];
    });
}

// TODO: 全量以后，一定时间需要清除下面逻辑
+ (void)disposeOldData {
    NSMutableArray *total = [NSMutableArray new];
    NSArray *normalDataArray = [GMCache fetchObjectAtDocumentPathWithkey:PhobosTempCacheKey];
    NSArray *immiDataArray = [GMCache fetchObjectAtDocumentPathWithkey:PhobosCacheKey];
    [total addObjectsFromArray:normalDataArray];
    [total addObjectsFromArray:immiDataArray];
    if (total.count > 0) {
        /** 获取非灰度下所有普通埋点，进行发送 */
        [self sendDataArray:total currentAPI:Phobos.sharedClient.serverAPI success:^(NSInteger code) {
            if (code == 200) {
                [GMCache removeObjectAtDocumentPathWithkey:PhobosCacheKey];
                [GMCache removeObjectAtDocumentPathWithkey:PhobosTempCacheKey];
            }
        }];
    }
    NSString *exposureAPI = [GMExposureManager sharedManager].uploadExposureAPI;
    if (exposureAPI) {
        NSString *str = [PhobosUtil MD5String:exposureAPI];
        NSArray *exposureArray = [GMCache fetchObjectAtDocumentPathWithkey:str];
        if (exposureArray.count > 0) {
            /** 获取非灰度下发送失败的埋点，进行发送 */
            [self sendDataArray:exposureArray currentAPI:exposureAPI success:^(NSInteger code) {
                if (code == 200) {
                    [GMCache removeObjectAtDocumentPathWithkey:[PhobosUtil MD5String:exposureAPI]];
                }
            }];
        }
    }
}

+ (void)sendDataWithEntities:(NSArray<GMPhobosSqulitModel *> *)sendDataEntities completion:(void (^)(NSArray<GMPhobosSqulitModel *> * _Nonnull, NSInteger))completion {
    if (sendDataEntities.count == 0) return;
    
    NSMutableDictionary *sendDataMap = [NSMutableDictionary new];
    // 将相同api的数据合并
    [sendDataEntities enumerateObjectsUsingBlock:^(GMPhobosSqulitModel *obj, NSUInteger idx, BOOL * _Nonnull stop) {
        NSMutableArray *sendData = sendDataMap[obj.api] ?: [NSMutableArray new];
        [sendData addObject:obj];
        [sendDataMap setValue:sendData forKey:obj.api];
    }];
    
    // 将实体转为待发送数据，取出PhobosSendDataEntity中的data，并发送
    [sendDataMap enumerateKeysAndObjectsUsingBlock:^(NSString *api, NSArray<GMPhobosSqulitModel *> *entities, BOOL * _Nonnull stop) {
        NSMutableArray *sendDatas = [NSMutableArray new];
        [entities enumerateObjectsUsingBlock:^(GMPhobosSqulitModel *obj, NSUInteger idx, BOOL * _Nonnull stop) {
            id data = [obj.data mj_JSONObject];
            if (data) {
                [sendDatas addObject:data];
            }
        }];
        
        if (sendDatas.count > 0) {
            [self sendDataArray:sendDatas currentAPI:api success:^(NSInteger code) {
                if (completion) {
                    completion(entities, code);
                }
            }];
        }
    }];
}

+ (void)sendDataArray:(NSArray *)dataArray currentAPI:(NSString *)currentAPI success:(SendDataSuccessBlock)success {
    NSData *JSON = [PhobosUtil encodeJSON:dataArray];
    NSData *compressedData = [PhobosUtil compressData:JSON];
    [PhobosUtil sendData:compressedData currentAPI:currentAPI success:^(NSInteger code) {
        if (success) {
            success(code);
        }
    }];
}

@end
