//
//  WMImageUploadOperation.m
//  Gengmei
//
//  Created by Sean Lee on 4/7/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "WMImageUploadOperation.h"
#import "WMNetService.h"

@implementation WMOperationQueue

+ (NSOperationQueue *)shareQueue
{
    static NSOperationQueue *sharedQueue = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        sharedQueue = [[WMOperationQueue alloc] init];
        [sharedQueue setMaxConcurrentOperationCount:1];
    });
    
    return sharedQueue;
}

@end


@interface WMImageUploadOperation ()
@property (nonatomic, strong) UIImage *image;
@property (nonatomic, strong) NSString *url;
@end

@implementation WMImageUploadOperation

- (instancetype)initWithImage:(UIImage *)image url:(NSString *)url
{
    if (self = [super init])
    {
        _image = image;
        _url = url;
    }
    return self;
}

- (void)main{
    
    NSData *imageData = UIImageJPEGRepresentation(_image, 1);
    __weak __typeof(self)weakSelf = self;
    
    [[WMNetService sharedInstance] sendUploadTaskRequestWithData:imageData fileName:@"file" name:@"file" url:_url mineType:@"image/jpeg" parameters:@{@"type":@"image"} success:^(NSDictionary* jsonData) {
        
        if (self.imageUploadFinishBlock) {
            weakSelf.imageUploadFinishBlock(jsonData);
        }
        
    } failed:^(NSString *errorMsg) {
        if (self.imageUploadFinishBlock) {
            weakSelf.imageUploadFinishBlock(nil);
        }
    }];
}

- (void)startUpload{
    
    [[WMOperationQueue shareQueue] addOperation:self];
}

@end
