//
//  GMExposureManager.h
//  Gengmei
//
//  Created by Mikasa on 2019/6/21.
//  Copyright © 2019 更美互动信息科技有限公司. All rights reserved.
//

#import "UIView+Tracker.h"
#import "UIScrollView+Tracker.h"
#import "UIViewController+Tracker.h"
#import "NSObject+Tracker.h"
/**
 * 精准曝光
 * 开始曝光时机：1、页面出现 2、退到后台
 */
typedef NS_ENUM(NSInteger, GMExpoUploadMode) {
    GMExpoUploadModeImmediate   = 0,// 立即上报
    GMExpoUploadModePage        = 1,// 按页面上报
    GMExpoUploadModeApp         = 2 // 按App上报
};// 精准曝光数据上报模式

typedef NS_ENUM(NSInteger, GMViewTrackerType) {
    GMViewTrackerTypeUIViewSetHidden            = 0,
    GMViewTrackerTypeUIViewSetAlpha             = 1,
    GMViewTrackerTypeUIViewDidMoveToWindow      = 2,
    GMViewTrackerTypeUIScrollContentOffset      = 3,
    GMViewTrackerTypeUIScrollDragging           = 4,
    GMViewTrackerTypeUIViewSetExposure          = 5,
    GMViewTrackerTypeUIViewEnterForeground      = 6,
    GMViewTrackerTypeUIViewDidAppear            = 7,
    GMViewTrackerTypeUIViewDidDisappear         = 8,
    GMViewTrackerTypeUIViewWillResignActive     = 9
}; // 记录方式

@interface GMExposureManager : NSObject
/// 设置上报数据地址
@property (nonatomic, copy) NSString *uploadExposureAPI;
/**
 * 精准曝光数据上报模式
 * 默认为 GMExpoUploadModePage
 */
@property (nonatomic, assign) GMExpoUploadMode uploadMode;

/** view出现的屏幕的占比 默认0.5f,如果后期再次修改为0.01时 需要修改老首页曝光逻辑 */
@property (nonatomic, assign) CGFloat exposureDimThreshold;// view visble in size > exposureDimThreshold
/** 曝光最少时长 默认0.01s (目前暂未使用)*/
@property (nonatomic, assign) NSTimeInterval exposureMinDuration;// view duration > exposureMinDuration
@property (nonatomic, assign) BOOL inBackground;// 当前App是否进入后台
@property (nonatomic, assign) BOOL ignoreTrackModel;// 是否需要忽略滚动模式


/**
 GMExposureManager

 @return sharedManager
 */
+ (instancetype)sharedManager;

#pragma mark - Deal Tracker
/**
 * 结束所有页面的曝光并上报
 * 会先将所有页面上正在曝光的View置为end,再进行数据上传
 */
- (void)endExpoTrcakerForAllPage;

/**
 * 结束指定页面的曝光并上报
 * 会先将指定页面上正在曝光的View置为end,再进行数据上传
 * 多用于下拉刷新前需要曝光当前的vc的数据

 @param pageCtrl 指定页面
 */
- (void)endExpoTrcakerForPageCtrl:(UIViewController *)pageCtrl;

#pragma mark - Deal Data
/**
 上传指定页面的曝光数据
 
 @param pageName 指定页面
 */
- (void)uploadExposureDataForPage:(UIViewController *)pageCtrl;

/**
 上传所有页面的曝光数据
 */
- (void)uploadAllExposureData;

// 存储曝光数据
- (void)startStoreExposureData;

/**
 清理指定页面的曝光数据
 
 @param pageName 指定页面
 */
- (void)clearExposureDataForPage:(UIViewController *)pageCtrl;

// 清理当前数据
- (void)clearAllExposureData;
/**
 当前View上是否有需要精准曝光的数据
 
 @param view View
 @return yes/no
 */
+ (BOOL)haveExposureForView:(UIView *)view;

#pragma mark - View Visible/UnVisibel
/**
获取当前View的可见状态

@param view view
@param 可见状态
*/
+ (BOOL)isViewVisible:(UIView *)view;

/**
 设置当前view是否可见状态
 
 @param view view
 @param recursive 是否递归子view
 @param ignoreTracking 是否忽略手势滚动时追踪
 */
+ (void)fetchViewForVisibleState:(UIView *)view  trackerType:(GMViewTrackerType)trackerType recursive:(BOOL)recursive;

/** 设置view的曝光状态
 * view 可见 && 状态none或者end——> 开始曝光
 * view 可见 && 状态start——> 正在曝光,不做处理
 * view 不可见 && 状态start ——> 结束曝光
 * view 不可见 && 状态none或者end ——> 不做处理
 */
- (void)exposureStatusForView:(UIView *)view inPageCtrl:(UIViewController *)inPageCtrl;
@end
