//
//  NSAttributedString+GMSize.h
//  Gengmei
//
//  Created by wangyang on 7/22/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface NSAttributedString (GMSize)

+ (NSMutableAttributedString *)string:(NSString *)string font:(UIFont *)font color:(UIColor *)color shadow:(BOOL)needShadow;
+ (NSMutableAttributedString *)attributedStringWithString:(NSString *)string fontSize:(CGFloat)size textColor:(UIColor *)color;

/**
 *  @brief  适用于为整个 string 添加属性，其中的 paragraphStyle 为 mutable 的，可以取出来再次修改
 @note 最佳使用方法: 用该方法创建 attributedString，再使用 sizeForBoundingRectSize: 方法来计算大小.
 @note 默认为 TruncatingTail
 
 */
+ (NSMutableAttributedString *)attributedStringWithString:(NSString *)string trimBothEndSpace:(BOOL)tripSpace trimInnerReturnSpace:(BOOL)trimReturn fontSize:(CGFloat)size textColor:(UIColor *)color lineSpacing:(CGFloat)spacing;

/**
 *  @brief  使用该方法返回 attributedString 的大小。比如指定{320， 99}，那么就会返回一个不超过该大小的 size，且宽高都经过 ceilf 处理
 *
 *  @param maxSize 指定的最大的 string 大小。
 *
 *  @return 经过 ceilf 处理的最大 size
 */
- (CGSize)sizeForBoundingRectSize:(CGSize)maxSize;
@end

@interface NSMutableAttributedString (GM)
- (void)addJustifiedAligment;
@end

@interface NSString (Attributed)
- (NSString *)trimInnerReturn;
- (NSString *)trimBothEnd;
- (NSMutableAttributedString *)fontSize:(NSInteger)size;
@end

@interface NSMutableAttributedString (Attributed)
- (NSMutableAttributedString *)addColor:(UIColor *)color;
- (NSMutableAttributedString *)addLineSpace:(NSInteger)space;
- (NSMutableAttributedString *)addShadow:(CGFloat)blur;
@end