//
//  NSNull+Empty.h
//  Gengmei
//
//  Created by licong on 12/28/15.
//  Copyright © 2015 Wanmeichuangyi. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface NSNull (Empty)

- (BOOL)isNonEmpty;

/**
 *  @brief  我们极力避免使用 string.length 的方式来判断空字符串。但是 string.length 除了用来判断，可能还会用在其它非判断的功能上。为了避免 [NSNull length] 而引起的 crash，还是给 NSNull 添加一个 length 方法比较安全。并且在 debug 情况下打印 log，以提示使用了 length 方法
 *
 *  @return 0
 */
- (NSUInteger)length;

@end
