//
//  UIViewController+KeyboardAnimation.h
//  yingshibaokaoyan
//
//  Created by wangyang on 7/17/14.
//  Copyright (c) 2014 com.zkyj.yingshibao.kaoyao. All rights reserved.
//

#import <UIKit/UIKit.h>

/**
 *  当键盘弹出或者收起时，会执行的block。在这个block里实现需要的UI变动
 *
 *  @param offkeyboardFrameset  将键盘转换为视图所在坐标第后，整个键盘View的Frame
 *  @param duration             动画时间
 *  @param curve                动画效果
 *  @param notification         通知
 */

typedef void(^ShowKeyboardAnimation)(CGRect keyboardFrame, CGFloat duration, NSInteger curve, NSNotification *notifcation);
typedef void(^HideKeyboardAnimation)(CGFloat duration, NSInteger curve, NSNotification *notifcation);
/**
 *  使用该类别，以方便的控制键盘事件
 */
@interface NSObject (KeyboardAnimation)


- (void)observeKeyboardForView:(UIView *)view showKeyboardAnimation:(ShowKeyboardAnimation)animation1 hideKeyboardAnimation:(HideKeyboardAnimation)animation2;

- (void)removeObservKeyboard;


@end
