//
//  NSString+GM.h
//  Gengmei
//
//  Created by licong on 12/28/15.
//  Copyright © 2015 Wanmeichuangyi. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 *  常用且按功能块比较难划分的扩展方法
 */

@interface NSString (GM)

/**
 *  @author licong, 16-12-28 12:12:13
 *
 *  判断一个字符串是否为空(包括nil/@""/nil)
 *
 *  @return 布尔值，YES表示字符串不为空，NO表示字符串为空
 *
 *  @since 5.8
 */
- (BOOL)isNonEmpty;

/*!
 *  @author zhaiguojun, 16-04-21
 *
 *  @brief 把字典和数组转成string
 *
 *  @param object
 *
 *  @return 转换后的string
 *
 *  @since 5.9.3
 */
+ (NSString*)dataToJsonString:(id)object;


/**
 *  @author licong, 16-12-28 12:12:16
 *
 *  得到非空string
 *
 *  @return 返回一个非空的字符串
 *
 *  @since 5.8
 */
+ (NSString *)safeStringWithString:(NSString *)string;


/**
 *  @author licong, 16-12-28 18:12:04
 *
 *  去除字符串中间和收尾的空格
 *
 *  @return 无空格的字符串
 *
 *  @since 5.8
 */
- (NSString*)trimSpace;


/**
 *  @brief  是否为纯数字
 *
 *  @param string 要检查的字符串
 *
 */
+ (BOOL)isPureInt:(NSString *)string;


/**
 *  @brief  是否为手机号
 *
 *  @param 0~9 11位即可
 *
 *
 *  @return
 */
+ (BOOL)isMobileNumber:(NSString *)mobileNum;

@end






/**
 *
 *  将类似URL的query参数解析成字典
 *
 */
@interface NSString (paresQuery)

/**
*  @author licong, 16-12-28 18:12:14
*
*  解析url中的query,转成字典格式
*
*  @return 解析好的字典
*
*  @since 5.8
*/

- (NSDictionary*)urlQueryToDictionary;


/**
 *  @author licong, 16-12-28 18:12:11
 *
 *  解析query字符串为字典比如:a=b&c=d
 *
 *  @return 解析好的字典
 *
 *  @since 5.8
 */
- (NSDictionary*)queryToDictionary;

@end





/**
 *
 *  根据String的Font计算String的size
 *
 */
@interface NSString (calculatorSize)


/**
 *  @author licong, 16-12-28 18:12:38
 *
 *  计算String当行间距为0的时候的高度和宽度
 *
 *  @param font String的font
 *  @param size String限定的size
 *
 *  @return String实际(如果是多行，则经过折行后)的size
 *
 *  @since 5.8
 */
- (CGSize)sizeWithFont:(UIFont *)font boundSize:(CGSize)size;


/**
 *  @author licong, 16-12-28 18:12:05
 *
 *  计算String在某个行间距下，高度和宽度
 *
 *  @param font        String的font
 *  @param size        String限定的size
 *  @param lineSpacing 设定的行间距
 *
 *  @return String在设定的行间距下，实际(如果是多行，则经过折行后)的size
 *
 *  @since 5.8
 */
- (CGSize)sizeWithFont:(UIFont *)font boundSize:(CGSize)size lineSpacing:(CGFloat)lineSpacing;

@end



@interface NSString (URLEncoding)

/**
 *  @author licong, 16-12-29 16:12:45
 *
 *  URL编码
 *
 *  @return 编码后的URL
 *
 *  @since 5.8
 */
- (NSString*) URLEncodedString;

/**
 *  @author licong, 16-12-29 16:12:08
 *
 *  URL解码
 *
 *  @return 解码URL
 *
 *  @since 5.8
 */
- (NSString*) URLDecodedString;

@end

