//
//  UIDevice+Reso.m
//  Simple UIDevice Category for handling different iOSs hardware resolutions
//
//  Created by Alejandro Luengo on 29/09/14.
//  (c) 2014 Intelygenz

#import <UIKit/UIKit.h>

typedef NS_ENUM(NSUInteger, UIDeviceResolution) {
   
    UnknowDevice   = 0,
    iPhone4     = 1,
    iPhone5     = 2,
    iPhone6     = 3,
    iPhone6Plus = 4,
    iPad        = 5,
    iPadRetina  = 6
    
};

@interface UIDevice (Resolutions) 


/**
 *  @author licong, 16-12-29 17:12:54
 *
 *  判断设备的类型（eg:当前设备是5还是6s）
 *
 *  @return 返回设备类型
 *
 *  @since 5.8
 */
+ (UIDeviceResolution)type;

/**
 获取设备的deviceId，如果能去到idfa，就返回idfa，否则就返回idfv
 @author zhaiguojun 16-10-31 in (null)
 @return deviceId
 @since 6.5.0
 */
+ (NSString *)deviceId;

/**
 *  @author licong, 16-12-29 16:12:13
 *
 *  获取设备的名字
 *
 *  @return 返回设备名字
 *
 *  @since 5.8
 */
+ (NSString*)deviceName;

/**
 获取设备详细类型，目前只到6s，和6s plus
 @author zhaiguojun 16-09-18 in (null)
 @return model
 @since 6.3.0
 */
+ (NSString*)deviceVersion;
@end
