//
//  UIImage+GM.h
//  Gengmei
//
//  Created by licong on 15/12/29. Rewrite by wangyang on 2016-7-4
//  Copyright © 2016年 Wanmeichuangyi. All rights reserved.
//

#import <UIKit/UIKit.h>
@interface UIImage (GM)

/**
 * @brief 通过颜色生成图片
 *
 * @param color 颜色
 */
+ (UIImage *)imageWithColor:(UIColor *)color;

/**
 *  @author licong, 16-12-29 18:12:48
 *
 *  将图片调整到设定大小
 *
 *  @param size 设定的图片大小
 *
 *  @return 得到设定大小后的图片
 *
 *  @since 5.8
 */
- (UIImage *)resizedImageWithSize:(CGSize)size;

/**
 *  @author wangyang in 2016-7-1
 *
 *  参考rotatedWithTransform
 */
- (UIImage *)rotatedWithAngle:(double)angle;

/**
 *  @author wangyang in 2016-7-1
 *
 *  使用这个方法旋转图片，导出的图片的imageOrientation为Up，绘制时会同时考虑待旋转图片的原 imageOrientation 与参数 transform

 @note
 1. 使用这个方法进行旋转，导出的图片大小可能会发生变化。比如旋转45度，那么能容下原图的bounds肯定要大一些；比如旋转90度，图片的高宽就会互换。
 2. 旋转角度为0时，可以用来将图片的imageOrientation重置为Up。
 *  @return 新图片
 */
- (UIImage *)rotatedWithTransform:(CGAffineTransform)transform;

/**
 *  @author wangyang in 2016-7-4
 *
 *  裁剪图片
 */
- (UIImage *)imageWithCropRect:(CGRect)rect;

@end