//
//  UITextView+Keyboard.m
//  ZhengXing
//
//  Created by Tulipa on 14-8-22.
//  Copyright (c) 2014年 Wanmei Creative. All rights reserved.
//

#import "UITextView+Keyboard.h"
#import "UIView+Layout.h"


@implementation UITextView (Keyboard)

- (BOOL)hasCloseButton
{
    return self.inputAccessoryView != nil;
}

- (void)setHasCloseButton:(BOOL)hasCloseButton
{
    if (hasCloseButton)
    {
        UIButton *closeButton = [UIButton buttonWithType:UIButtonTypeCustom];
        [closeButton setBackgroundImage:[UIImage imageNamed:@"keyboard"] forState:UIControlStateNormal];
        [closeButton sizeToFit];
        
        UIView *view = [[UIView alloc] initWithFrame:CGRectMake(0, 0, [[UIScreen mainScreen] bounds].size.width, closeButton.height)];
        [view addSubview:closeButton];
        [view setBackgroundColor:[UIColor clearColor]];
        [closeButton setRight:view.width];
        [closeButton setTop:0];
        
        [closeButton addTarget:self action:@selector(resignFirstResponder) forControlEvents:UIControlEventTouchUpInside];
        self.inputAccessoryView = view;
    }
    else
    {
        self.inputAccessoryView = nil;
    }
}

@end

@implementation UITextField (Keyboard)

- (BOOL)hasCloseButton
{
    return self.inputAccessoryView != nil;
}

- (void)setHasCloseButton:(BOOL)hasCloseButton
{
    if (hasCloseButton)
    {
        UIButton *closeButton = [UIButton buttonWithType:UIButtonTypeCustom];
        [closeButton setBackgroundImage:[UIImage imageNamed:@"keyboard"] forState:UIControlStateNormal];
        [closeButton sizeToFit];
        
        UIView *view = [[UIView alloc] initWithFrame:CGRectMake(0, 0, [[UIScreen mainScreen] bounds].size.width, closeButton.height)];
        [view addSubview:closeButton];
        [view setBackgroundColor:[UIColor clearColor]];
        [closeButton setRight:view.width];
        [closeButton setTop:0];
        
        [closeButton addTarget:self action:@selector(resignFirstResponder) forControlEvents:UIControlEventTouchUpInside];
        self.inputAccessoryView = view;
    }
    else
    {
        self.inputAccessoryView = nil;
    }
}

@end
