//
//  UIView+LineWithAutolayout.h
//  ZhengXing
//
//  Created by wangyang on 11/6/14.
//  Copyright (c) 2014 Wanmei Creative. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface UIView (LineWithAutolayout)

/**
 *  @author licong, 16-12-28 19:12:48
 *
 *  alloc一个无固定大小的view,用作分割线
 *
 *  @return 返回一个view
 *
 *  @since 5.8
 */
- (UIView *)addLineWithoutFrame;

/**
 *  @author licong, 16-12-28 19:12:16
 *
 *  在指定view(就是self)的最上边缘，加一根与指定view宽度相等的头部边缘线
 *
 *  @return 返回alloc的分割线
 *
 *  @since 5.8
 */
- (UIView *)addTopLine;

/**
 *  @author licong, 16-12-28 19:12:16
 *
 *  在view(就是self)的最下边缘，加一根与指定view宽度相等的底部边缘线
 *
 *  @return 返回alloc的分割线
 *
 *  @since 5.8
 */
- (UIView *)addBottomLine;


/**
 *  @author licong, 16-12-28 19:13:30
 *
 *  给指定的view(就是self)，加一跟中心水平线
 *
 *  @param left    竖直线距离设定的view左边的距离
 *  @param right   竖直线距离设定的view右边的距离
 *
 *  @return 返回alloc的中心竖直线
 *
 *  @since 5.8
 */
- (UIView *)addCenterHorizontalLineWithLeft:(CGFloat)left right:(CGFloat)right;


/**
 *  @author licong, 16-12-28 19:12:40
 *
 *  给指定的view(就是self)，加一跟中心竖直线
 *
 *  @param top    竖直线距离设定的view上边的距离
 *  @param bottom 竖直线距离设定的view下边的距离
 *
 *  @return 返回alloc的中心竖直线
 *
 *  @since 5.8
 */
- (UIView *)addCenterVerticalLineWithTop:(CGFloat)top bottom:(CGFloat)bottom;


/**
 *  @author licong, 16-12-28 19:12:19
 *
 *  给指定的view(就是self)的最下边缘，加一根长度可设置的头部边缘线（最长不超过该view的宽度）
 *
 *  @param left  头部边缘线距离设定view左边的距离
 *  @param right 头部边缘线距离设定view左边的距离
 *
 *  @return 返回长度可设置的头部边缘线
 *
 *  @since 5.8
 */
- (UIView *)addTopLineWithLeft:(CGFloat)left right:(CGFloat)right;


/**
 *  @author licong, 16-12-28 19:12:16
 *
 *  给指定的view(就是self)的最下边缘，加一根长度可设置的底部边缘线（最长不超过该view的宽度）
 *
 *  @param left  底部边缘线距离设定view左边缘的距离
 *  @param right 底部边缘线距离设定view右边缘的距离
 *
 *  @return 返回长度可设置的底部边缘线
 *
 *  @since 5.8
 */
- (UIView *)addBottomLineWithLeft:(CGFloat)left right:(CGFloat)right;



/**
 *  @author licong, 16-12-29 11:12:02
 *
 *  给指定的view(就是self)，加一根长度可设置的水平线，以Top为Y方向的基准点
 *
 *  @param top   水平线距离设定view上边缘的距离
 *  @param left  水平线距离设定view左边缘的距离
 *  @param right 水平线距离设定view右边缘的距离
 *
 *  @return 返回水平线
 *
 *  @since 5.8
 */
- (UIView *)addHorizontalLineWithTop:(CGFloat)top left:(CGFloat)left right:(CGFloat)right;
/**
 *  @author licong, 16-12-29 11:12:48
 *
 *  给指定的view(就是self)，加一根长度可设置的水平线，以Bottom为Y方向的基准点
 *
 *  @param bottom 水平线距离设定view下边缘的距离
 *  @param left   水平线距离设定view左边缘的距离
 *  @param right  水平线距离设定view右边缘的距离
 *
 *  @return 返回水平线
 *
 *  @since 5.8
 */
- (UIView *)addHorizontalLineWithBottom:(CGFloat)bottom left:(CGFloat)left right:(CGFloat)right;


/**
 *  @author licong, 16-12-29 11:12:48
 *
 *  给指定的view(就是self)，加一根长度可设置的竖直线，以Left为X方向的基准点
 *
 *  @param left   竖直线距离设定view左边缘的距离
 *  @param top    竖直线距离设定view上边缘的距离
 *  @param bottom 竖直线距离设定view下边缘的距离
 *
 *  @return 返回竖直线
 *
 *  @since 5.8
 */
- (UIView *)addVerticalLineWithLeft:(CGFloat)left top:(CGFloat)top bottom:(CGFloat)bottom;

/**
 *  @author licong, 16-12-29 11:12:54
 *
 *  给指定的view(就是self)，加一根长度可设置的竖直线，以Right为X方向的基准点
 *
 *  @param right  竖直线距离设定view右边缘的距离
 *  @param top    竖直线距离设定view上边缘的距离
 *  @param bottom 竖直线距离设定view下边缘的距离
 *
 *  @return 返回竖直线
 *
 *  @since 58
 */
- (UIView *)addVerticalLineWithRight:(CGFloat)right top:(CGFloat)top bottom:(CGFloat)bottom;
@end

