//
//  GMButton.m
//  Gengmei
//
//  Created by Thierry on 12/26/14.
//  Copyright (c) 2014 Wanmeichuangyi. All rights reserved.
//

#import "GMButton.h"
#import "GMFont.h"
#import "GMTheme.h"
#import "GMConstant.h"

@interface GMButton ()
@property (nonatomic, strong) UIColor *highlightBackgroundColor;
@property (nonatomic, strong) UIColor *normalBackgroundColor;
@property (nonatomic, strong) UIColor *selectedBackgroundColor;
@property (nonatomic, strong) UIColor *disableBackgroundColor;

@property (nonatomic, assign) GMButtonType customType;
@property (nonatomic, strong) UIColor *normalBorderColor;
@property (nonatomic, strong) UIColor *disableBorderColor;
@end

@implementation GMButton

#pragma mark - 初始化
-(id)init
{
    self = [super init];
    if (self) {
        [self setup];
    }
    return self;
}

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)awakeFromNib{
    [super awakeFromNib];
    [self setup];
}

- (void)setup{
    _adaptiveHotAreaWidth = 44.0;
    _adaptiveHotAreaHeight = 44.0;
    _normalBackgroundColor = [UIColor clearColor];
}


#pragma mark - 实例化方法

+ (instancetype)buttonWithTitle:(NSString *)title
                backgroundColor:(UIColor *)bgColor
                  titleFontSize:(CGFloat)size
                     titleColor:(UIColor *)titleColor{
    GMButton *button = [GMButton buttonWithType:UIButtonTypeCustom];
    if (bgColor) {
        button.backgroundColor = bgColor;
    }
    if (title) {
        [button setTitle:title forState:UIControlStateNormal];
    }
    if (size > 0) {
        button.titleLabel.font = GMFont(14);
    }
    if (titleColor) {
        [button setTitleColor:titleColor forState:UIControlStateNormal];
    }

    return button;
}


+ (instancetype)buttonWithCustomType:(GMButtonType)customType{
    
    GMButton *button = [GMButton buttonWithType:UIButtonTypeCustom];
    button.clipsToBounds = YES;
    button.customType = customType;
    [button setTitle:@"按钮" forState:UIControlStateNormal];
    switch (customType) {
        case GMButtonTypeGreen:
            [button setGreenAppearance];
            break;
        case GMButtonTypeGreenRound:
            [button setGreenAppearance];
            button.layer.cornerRadius = 6 * ONE_PIXEL;
            break;
        case GMButtonTypeGreenSemicircle:
            [button setGreenAppearance];
            break;
        case GMButtonTypeGreenBorder:
            button.layer.borderWidth = ONE_PIXEL;
            button.layer.cornerRadius = 6 * ONE_PIXEL;
            button.normalBorderColor = MAIN_VISUAL_COLOR;
            button.disableBorderColor = DISABLE_COLOR;
            [button setBackgroundColor: [UIColor clearColor] forState:UIControlStateNormal];
            [button setTitleColor:MAIN_VISUAL_COLOR forState:UIControlStateNormal];
            [button setTitleColor:DISABLE_COLOR forState:UIControlStateDisabled];
            button.enabled = YES;
            break;
        case GMButtonTypeRed:
            [button setRedAppearance];
            break;
        case GMButtonTypeRedRound:
            [button setRedAppearance];
            button.layer.cornerRadius = 6 * ONE_PIXEL;
            break;
        case GMButtonTypeRedSemicircle:
            [button setRedAppearance];
            break;
        case GMButtonTypeRedBorder:
            button.layer.borderWidth = ONE_PIXEL;
            button.layer.cornerRadius = 6 * ONE_PIXEL;
            button.normalBorderColor = SECONDARY_VISUAL_COLOR;
            button.disableBorderColor = DISABLE_COLOR;
            [button setBackgroundColor: [UIColor clearColor] forState:UIControlStateNormal];
            [button setTitleColor:SECONDARY_VISUAL_COLOR forState:UIControlStateNormal];
            [button setTitleColor:DISABLE_COLOR forState:UIControlStateDisabled];
            button.enabled = YES;
            break;
        case GMButtonTypeGrayBorderSemicircle:
            button.layer.borderColor =  SEPARATOR_LINE_COLOR.CGColor;
            button.layer.borderWidth = ONE_PIXEL;
            [button setBackgroundColor: BACKGROUND_COLOR forState:UIControlStateNormal];
            [button setBackgroundColor: SEPARATOR_LINE_COLOR forState:UIControlStateHighlighted];
            [button setTitleColor:BODY_TEXT_COLOR forState:UIControlStateNormal];
        default:
            break;
    }
    return button;
}


//为半圆的设置半径
- (void)layoutSubviews{
    [super layoutSubviews];
    if (_customType == GMButtonTypeGreenSemicircle || _customType == GMButtonTypeRedSemicircle || _customType == GMButtonTypeGrayBorderSemicircle) {
        self.layer.cornerRadius = MIN(self.frame.size.height, self.frame.size.width)/2;
    }
}

#pragma mark - Button Appearance

- (void)setGreenAppearance{
    [self setTitleColor:WHITE_COLOR forState:UIControlStateNormal];
    [self setBackgroundColor:BUTTON_NOMARL_GREEN_COLOR forState:UIControlStateNormal];
    [self setBackgroundColor:BUTTON_HIGHLIGHT_GREEN_COLOR forState:UIControlStateHighlighted];
    [self setBackgroundColor:BUTTON_DISABLE_COLOR forState:UIControlStateDisabled];
}

- (void)setRedAppearance{
    [self setTitleColor:WHITE_COLOR forState:UIControlStateNormal];
    [self setBackgroundColor:BUTTON_NOMARL_RED_COLOR forState:UIControlStateNormal];
    [self setBackgroundColor:BUTTON_HIGHLIGHT_RED_COLOR forState:UIControlStateHighlighted];
    [self setBackgroundColor:BUTTON_DISABLE_COLOR forState:UIControlStateDisabled];
}


#pragma mark - Background Color

- (void)setBackgroundColor:(UIColor *)backgroundColor forState:(UIControlState)state{
    if (state == UIControlStateNormal) {
        _normalBackgroundColor = backgroundColor;
        [self setBackgroundColor:_normalBackgroundColor];
    }else if (state == UIControlStateHighlighted){
        _highlightBackgroundColor = backgroundColor;
    }else if (state == UIControlStateSelected){
        _selectedBackgroundColor = backgroundColor;
    }else if (state == UIControlStateDisabled) {
        _disableBackgroundColor = backgroundColor;
    }
}


#pragma mark - Setter
- (void)setHighlighted:(BOOL)highlighted
{
    [super setHighlighted:highlighted];
    if (_highlightBackgroundColor && highlighted) {
        self.backgroundColor = _highlightBackgroundColor;
    }else{
        if (self.selected && _selectedBackgroundColor) {
            self.backgroundColor = _selectedBackgroundColor;
        }else{
            self.backgroundColor = _normalBackgroundColor;
        }
        
    }
}

- (void)setSelected:(BOOL)selected{
    [super setSelected:selected];
    if (_selectedBackgroundColor && selected) {
        self.backgroundColor = _selectedBackgroundColor;
    }else{
        self.backgroundColor = _normalBackgroundColor;
    }
}


- (void)setBackgroundColor:(UIColor *)backgroundColor{
    [super setBackgroundColor:backgroundColor];
    
    // 容错处理，只在为normal状态，才设置_normalBackgroundColor。
    // 比如在controller里只调用了setBackgroundColor，为了保证在normal时回复到normal颜色，必须设置好_normalBackgroundColor
    if(self.state == UIControlStateNormal){
        _normalBackgroundColor = backgroundColor;
    }
}

- (void)setEnabled:(BOOL)enabled{
    [super setEnabled:enabled];
    if (enabled) {
        self.backgroundColor = _normalBackgroundColor;
        if (_customType == GMButtonTypeGreenBorder || _customType == GMButtonTypeRedBorder) {
            self.layer.borderColor =  _normalBorderColor.CGColor;
        }
    }else{
        self.backgroundColor = _disableBackgroundColor;
        if (_customType == GMButtonTypeGreenBorder || _customType == GMButtonTypeRedBorder) {
            self.layer.borderColor =  _disableBorderColor.CGColor;
        }
    }
}

#pragma mark - 支持自适应热区

- (BOOL)pointInside:(CGPoint)point withEvent:(UIEvent *)event{
    
    //默认不支持放大热区
    if (!_enableAdaptive) {
        return  [super pointInside:point withEvent:event];
    }
    
    CGRect bounds = self.bounds;
    
    //若原热区小于 _adaptiveHotAreaWidth x _adaptiveHotAreaHeight，则放大热区，否则保持原大小不变
    CGFloat widthDelta = MAX(_adaptiveHotAreaWidth - bounds.size.width, 0);
    CGFloat heightDelta = MAX(_adaptiveHotAreaHeight - bounds.size.height, 0);
    bounds = CGRectInset(bounds, -0.5 * widthDelta, -0.5 * heightDelta);
    return CGRectContainsPoint(bounds, point);
    
}




@end
