//
//  GMSimpleCell.m
//  Gengmei
//
//  Created by Thierry on 1/7/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "GMCollectionViewCell.h"
#import "GMFont.h"
#import "GMConstant.h"
#import "GMTheme.h"
#define CELL_HEIGHT self.contentView.frame.size.height
#define CELL_WIDTH self.contentView.frame.size.width

@implementation GMCollectionViewCell

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)awakeFromNib{
    [super awakeFromNib];
    [self setup];
}

- (void)setup{
    
    self.clipsToBounds = YES;
    _imageView = [[GMImageView alloc] initWithFrame:CGRectMake((CELL_WIDTH-45)/2, 10, 45, 45)];
    _label = [[GMLabel alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(_imageView.frame)+6, CELL_WIDTH, 13)];
    _label.textColor = HEADLINE_TEXT_COLOR;
    _label.font = GMFont(12);
    [_label setTextAlignment:NSTextAlignmentCenter];
    [self.contentView addSubview:_imageView];
    [self.contentView addSubview:_label];
    
}


@end
