//
//  GMDatePicker.m
//  ZhengXing
//
//  Created by Sean Lee on 11/19/14.
//  Copyright (c) 2014 Wanmei Creative. All rights reserved.
//

#import "GMDatePickerView.h"
#import "GMFont.h"
#import <Masonry/Masonry.h>
#import "GMConstant.h"
#import "GMTheme.h"

#define DATAPICKER_HEIGHT

@interface GMDatePickerView ()

@property (nonatomic,strong)UIButton * leftButton;
@property (nonatomic,strong)UILabel  * titleLabel;
@property (nonatomic,strong)UIButton * rightButton;

@end


@implementation GMDatePickerView

- (id)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = [UIColor colorWithWhite:0 alpha:.6];
        self.hidden = YES;
        [self createDatePicker];
        
    }
    return self;
}

- (void)createDatePicker{
    
    _contentView = [[UIView alloc]initWithFrame:CGRectZero];
    _contentView.frame = CGRectMake(0, [[UIScreen mainScreen] bounds].size.width, self.frame.size.width, 255);
    _contentView.backgroundColor = [UIColor whiteColor];
    [self addSubview:_contentView];
    
    _picker = [[UIDatePicker alloc]initWithFrame:CGRectMake(0, 39, [[UIScreen mainScreen] bounds].size.width, 216)];
    _picker.backgroundColor = [UIColor whiteColor];
    _picker.datePickerMode = UIDatePickerModeDate;
    //2037-12-31 23:59:59的时间戳
    _picker.maximumDate = [NSDate dateWithTimeIntervalSince1970:2145887999];
    [_picker setDate:[NSDate date] animated:NO];
    [_picker addTarget:self action:@selector(didPickerSelected:) forControlEvents:UIControlEventValueChanged];
    [_contentView addSubview:_picker];
    _picker.layer.borderWidth = 1;
    _picker.layer.borderColor = SEPARATOR_LINE_COLOR.CGColor;
    
    
    _leftButton = [UIButton buttonWithType:UIButtonTypeCustom];
    _leftButton.tag = 1;
    _leftButton.hidden = YES;
    [_contentView addSubview:_leftButton];
    [_leftButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_contentView.mas_left).with.offset(16);
        make.top.equalTo(_contentView.mas_top).offset(4);

    }];
    [_leftButton.titleLabel setFont:GMFont(16)];
    [_leftButton setTitleColor:MAIN_VISUAL_COLOR forState:UIControlStateNormal];
    [_leftButton addTarget:self action:@selector(confirmButtonClicked:) forControlEvents:UIControlEventTouchUpInside];
    
    
    _titleLabel = [[UILabel alloc]init];
    _titleLabel.hidden = YES;
    _titleLabel.font = GMFont(17);
    [_titleLabel setTextColor:[UIColor blackColor]];
    [_contentView addSubview:_titleLabel];
    [_titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(_contentView);
        make.top.equalTo(_leftButton.mas_top).with.offset(6);
        
    }];

    
    _rightButton = [UIButton buttonWithType:UIButtonTypeCustom];
    _rightButton.tag = 2;
    [_contentView addSubview:_rightButton];
    [_rightButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(_contentView.mas_right).with.offset(-16);
        make.top.equalTo(_contentView.mas_top).offset(4);
    }];
    [_rightButton setTitleColor:MAIN_VISUAL_COLOR forState:UIControlStateNormal];
    [_rightButton setTitle:@"确定" forState:UIControlStateNormal];
    [_rightButton.titleLabel setFont:GMFont(16)];
    [_rightButton addTarget:self action:@selector(confirmButtonClicked:) forControlEvents:UIControlEventTouchUpInside];
    
    
    
    UITapGestureRecognizer *tapGesture = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(tap:)];
    tapGesture.delegate = self;
    [self addGestureRecognizer:tapGesture];
}


- (void)setLeftButtonTitle:(NSString *)leftButtonTitle{
    _leftButtonTitle= leftButtonTitle;
    _leftButton.hidden = NO;
    [_leftButton setTitle:leftButtonTitle forState:UIControlStateNormal];
}

- (void)setTitleLabelTitle:(NSString *)titleLabelTitle{
    _titleLabelTitle = titleLabelTitle;
    _titleLabel.hidden = NO;
    _titleLabel.text = titleLabelTitle;
}

- (void)didPickerSelected:(id)sender{

    if (self.confirmButtonClickBolck) {
        self.confirmButtonClickBolck(_picker.date);
    }
}

- (void)confirmButtonClicked:(id)sender{
    
    UIButton * button = (UIButton *)sender;
    if (button.tag ==1) {
        if (self.confirmButtonClickBolck) {
            self.confirmButtonClickBolck(nil);
        }
    }else if(button.tag == 2){
        if (self.confirmButtonClickBolck) {
            self.confirmButtonClickBolck(_picker.date);
        }
    }
    
    
    [self hide];

}

- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldRecognizeSimultaneouslyWithGestureRecognizer:(UIGestureRecognizer *)otherGestureRecognizer
{
    return YES;
}

- (BOOL)gestureRecognizerShouldBegin:(UIGestureRecognizer *)gestureRecognizer
{
    if([gestureRecognizer isKindOfClass:[UITapGestureRecognizer class]])
    {
        CGPoint touch = [gestureRecognizer locationInView:self];
        if(!CGRectContainsPoint(_contentView.frame, touch))
        {
            return YES;
        }
        return NO;
    }
    return YES;
    
}

- (void)tap:(UITapGestureRecognizer *)recognizer
{
    
    if ([self.delegate respondsToSelector:@selector(openPicker)]) {
        [self.delegate openPicker];
    }
}


-(void)show
{
    [_picker setDate:[NSDate date] animated:NO];
    [UIView animateWithDuration:0.2 delay:0.0f options:UIViewAnimationOptionCurveEaseInOut animations:^{
        self.contentView.frame = CGRectMake(0, MAINSCREEN_HEIGHT - 255, MAINSCREEN_WIDTH, self.contentView.frame.size.height);
    } completion:^(BOOL finished) {
    }];
}

-(void)hide
{
    [UIView animateWithDuration:0.2 delay:0.0f options:UIViewAnimationOptionCurveEaseInOut animations:^{
        self.contentView.frame = CGRectMake(0, MAINSCREEN_HEIGHT, MAINSCREEN_WIDTH, self.contentView.frame.size.height);
        self.backgroundColor = [UIColor colorWithWhite:0 alpha:0];
        
    } completion:^(BOOL finished) {
        
        self.hidden = YES;
        self.backgroundColor = [UIColor colorWithWhite:0 alpha:.3];
    }];
}
@end
