//
//  GMHightlightLabel.m
//  Gengmei
//
//  Created by wangyang on 6/11/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "GMHighlightLabel.h"
#import "GMFont.h"
#import "GMConstant.h"
#import "GMTheme.h"

@implementation GMHighlightLabel

- (void)setOriginalHightlightText:(NSString *)originalHightlightText{
    _originalHightlightText = originalHightlightText;
    if (_originalHightlightText.length == 0) {
        self.attributedText = nil;
    }
    
    if (!_hightlightColor) {
        _hightlightColor = MAIN_VISUAL_COLOR;
    }
    
    if (!_normalColor) {
        _normalColor = BODY_TEXT_COLOR;
    }
    
    
    NSMutableAttributedString *attString = [self parseString:_originalHightlightText];
    
    
    NSMutableParagraphStyle *style = [[NSMutableParagraphStyle alloc] init];
    style.lineSpacing = _lineHeight;
    style.lineBreakMode = NSLineBreakByTruncatingTail;
    style.alignment = _aligment;
    // 如果有高亮，attString不为空，那只加一个NSParagraphStyleAttributeName属性
    if (self.lineHeight > 0 && attString.length > 0) {
        [attString addAttribute:NSParagraphStyleAttributeName value:style range:NSMakeRange(0, attString.length)];
    }
    
    // 如果没有走到正则里面，说明没有需要高亮的内容，设置普通颜色就好
    else if (attString.length == 0) {
        NSAttributedString *subString = [[NSAttributedString alloc] initWithString:_originalHightlightText attributes:@{NSFontAttributeName : self.font, NSForegroundColorAttributeName:_normalColor, NSParagraphStyleAttributeName:style}];
        [attString appendAttributedString:subString];
    }
    
    self.attributedText = attString;

}

- (NSMutableAttributedString *)parseString:(NSString *)originalString{
    NSError *error;
    NSRegularExpression *expression = [NSRegularExpression regularExpressionWithPattern:@"([\\w\\W]*)<ems>([\\w\\W]+)<\\/ems>([\\w\\W]*)" options:0 error:&error];
    
    if (error) {
        self.attributedText = nil;
    }
    
    NSMutableAttributedString *attString = [[NSMutableAttributedString alloc] init];
    
    [expression enumerateMatchesInString:originalString options:0 range:NSMakeRange(0, originalString.length) usingBlock:^(NSTextCheckingResult *result, NSMatchingFlags flags, BOOL *stop) {
        
        // 根据NSTextCheckingResult的rangeAtIndex方法文档，result至少会有一个range，这个range是匹配它自身全部的，所以正则匹配的其它range是从1开始的
        
        // <ems></ems>将string分隔为string1, string2, string3，分别对应前中后
        
        NSString *string1 = [originalString substringWithRange:[result rangeAtIndex:1]];
        NSAttributedString *attrString1 = [self parseString:string1];
        if (attrString1.length > 0) {
            [attString appendAttributedString:attrString1];
        }else{
            NSAttributedString *subString = [[NSAttributedString alloc] initWithString:string1 attributes:@{NSFontAttributeName : self.font, NSForegroundColorAttributeName:_normalColor}];
            [attString appendAttributedString:subString];
        }
        
        
        NSString *string2 = [originalString substringWithRange:[result rangeAtIndex:2]];
        NSAttributedString *attrString2 = [self parseString:string2];
        if (attrString2.length > 0) {
            [attString appendAttributedString:attrString2];
        }else{
            NSAttributedString *subString = [[NSAttributedString alloc] initWithString:string2 attributes:@{NSFontAttributeName : self.font, NSForegroundColorAttributeName:_hightlightColor}];
            [attString appendAttributedString:subString];
        }
        
        
        NSString *string3 = [originalString substringWithRange:[result rangeAtIndex:3]];
        NSAttributedString *attrString3 = [self parseString:string3];
        if (attrString3.length > 0) {
            [attString appendAttributedString:attrString3];
        }else{
            NSAttributedString *subString = [[NSAttributedString alloc] initWithString:string3 attributes:@{NSFontAttributeName : self.font, NSForegroundColorAttributeName:_normalColor}];
            [attString appendAttributedString:subString];
        }
        
    }];

    
    return attString;
}

+ (GMHighlightLabel *)hightLabelTextColor:(UIColor *)color andFont:(CGFloat)font {
    
    GMHighlightLabel *label = [[GMHighlightLabel alloc] init];
    label.backgroundColor = [UIColor whiteColor];
    label.textColor = color;
    label.font = GMFont(font);
    label.hightlightColor = MAIN_VISUAL_COLOR;
    return label;
}

@end
