//
//  GMHorizontalLayoutButton.m
//  Gengmei
//
//  Created by wangyang on 8/17/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "GMHorizontalLayoutButton.h"
#import "GMFont.h"
#import "NSString+GM.h"

@interface GMHorizontalLayoutButton ()
@property(nonatomic, assign)CGFloat finalSpace;
@end

@implementation GMHorizontalLayoutButton
- (void)setImageArrangeType:(GMButtonImageArrangeType)imageArrangeType{
    _imageArrangeType = imageArrangeType;
    [self arrangeByImageArrangeType:imageArrangeType];
}

- (void)arrangeByImageArrangeType:(GMButtonImageArrangeType)imageArrangeType{
    if (imageArrangeType == GMButtonImageArrangeLeftType) {
        _finalSpace = self.imageAndTitleSpace/2.0;
        self.titleEdgeInsets = UIEdgeInsetsMake(0, _finalSpace, 0, 0);
        self.imageEdgeInsets = UIEdgeInsetsMake(0, 0, 0, _finalSpace);
    }else{

        CGFloat titleWidth = [self.currentTitle sizeWithFont:self.titleLabel.font boundSize:CGSizeMake(CGFLOAT_MAX, CGFLOAT_MAX)].width;
        _finalSpace =  self.imageAndTitleSpace * 2 + titleWidth;

        CGFloat imageWidth = self.currentImage.size.width * [UIScreen mainScreen].scale;
        self.titleEdgeInsets = UIEdgeInsetsMake(0, -(imageWidth + self.imageAndTitleSpace * 2), 0, 0);
        self.imageEdgeInsets = UIEdgeInsetsMake(0, _finalSpace, 0, 0);
    }
}

- (void)updateConstraints{
    [self arrangeByImageArrangeType:self.imageArrangeType];
    [super updateConstraints];
}

- (CGSize)intrinsicContentSize{
    CGSize size = [super intrinsicContentSize];
    size.width += self.imageAndTitleSpace;
    return size;
}

@end
