//
//  GMInfiniteScrollView.h
//  
//
//  Created by wangyang on 10/12/15.
//  Copyright (c) 2015年 Wanmeichuangyi. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "GMView.h"

@class GMInfiniteScrollView;

@protocol GMInfinitelViewDelegate <NSObject>

@optional

- (void)infiniteScrollView:(GMInfiniteScrollView *)infiniteScrollView didSelectIndex:(NSInteger)index;

@end


@interface GMInfiniteScrollView : GMView <UIScrollViewDelegate>{
    
    UIScrollView *_scrollView;
    NSInteger _currentPage;
}

@property (nonatomic, assign) id<GMInfinitelViewDelegate> delegate;

/**
 *  @author licong, 16-12-31 18:12:50
 *
 *  轮播图片的填充模式
 *
 *  @since 5.8
 */
@property (nonatomic, assign) UIViewContentMode imageContentMode;

// 存放所有需要滚动的图片URL NSString

/**
 *  @author licong, 16-12-31 17:12:26
 *
 *  需要轮播的数据源
 *
 *  @since 5.8
 */
@property (nonatomic, strong) NSArray *imageArray;

/**
 *  @author licong, 16-12-31 18:12:11
 *
 *  轮播的时间间隔
 *
 *  @since 5.8
 */
@property (nonatomic, assign) NSTimeInterval timeInterval;

/**
 *  @author licong, 16-12-31 18:12:42
 *
 *  pageControl
 *
 *  @since 5.8
 */
@property (nonatomic, strong) UIPageControl *pageControl;

/**
 *  @author licong, 16-12-31 18:12:09
 *
 *  是否允许手动滚动
 *
 *  @since 5.8
 */
@property (nonatomic, assign) BOOL enableRolling;

/**
 *  @author licong, 16-12-31 18:12:34
 *
 *  开始轮播
 *
 *  @since 5.8
 */
- (void)startRolling;

/**
 *  @author licong, 16-12-31 18:12:48
 *
 *  停止轮播
 *
 *  @since 5.8
 */
- (void)stopRolling;

@end



