//
//  PreListView.h
//  Gengmei
//
//  Created by Sean Lee on 4/7/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "GMPreviewCell.h"
#import "GMView.h"

#define PREVIRE_CELL_HEIGHT  PREVIRE_CELL_WIDTH
#define PREVIRE_CELL_WIDTH  (MAINSCREEN_WIDTH - 30 - PREVIRE_CELL_SPACE * 3)/4      // 每一个unitCell的默认宽度
#define PREVIRE_CELL_SPACE   5                                                      // unitCell之间的间距
#define DURATION      0.5                                                           // 动画执行时间
#define DEFAULT_VISIBLE_COUNT 4                                                     //默认显示的unitCell的个数


@protocol GMPreviewListViewDelegate <NSObject>

@optional
- (void)addPreviewCell;

- (void)retryUploadPreviewCell:(GMPreviewCell *)cell;

- (void)deletePreviewCell:(NSInteger )index;

- (void)fullScreenImage:(GMPreviewCell *)cell;

@end

@interface GMPreviewListView : GMView

@property (nonatomic, strong) NSMutableArray *previewList;
@property (nonatomic,assign)id<GMPreviewListViewDelegate>delegate;

/**
 *  @brief  添加一个预览图，并返回生成好的cell的位置
 *
 *  @param image cell里装载的图片
 */

- (GMPreviewCell * ) addImage:(UIImage *)image;

/***  @brief 开始上传，显示loading */
- (void)showLoadingAtIndex:(NSInteger)index;
/***  @brief 上传成功，隐藏loading */
- (void)hideLoadingAtIndex:(NSInteger)index;
/***  @brief 重新上传loading */
- (void)retryLoadingAtIndex:(NSInteger)index;

@end
