//
//  GMBaseTableView.m
//  Gengmei
//
//  Created by 翟国钧 on 15/1/14.
//  Copyright (c) 2015年 Wanmeichuangyi. All rights reserved.
//

#import "GMTableView.h"
#import "UIView+Layout.h"

@implementation GMTableView

- (instancetype)initWithCoder:(NSCoder *)coder
{
    self = [super initWithCoder:coder];
    if (self) {
        [self setup];
    }
    return self;
}


- (instancetype)initWithFrame:(CGRect)frame style:(UITableViewStyle)style{
    self = [super initWithFrame:frame style:style];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup{
    self.keyboardDismissMode = UIScrollViewKeyboardDismissModeOnDrag;
    self.separatorStyle = UITableViewCellSeparatorStyleNone;
}

@end

@implementation GMTableView (FixWierdTableHeaderAnimation)


- (void)fixWierdTableHeaderAnimationWhenRefreshFinish{

    if (self.tableHeaderView.height > 0) {
        return;
    }

    // 我们希望在拖动时 section header 可以浮在上面，所以使用 scrollView.dragging 来区分。
    if (self.dragging) {

        // 在手动拖拽时，立即设置 contentInset 为 UIEdgeInsetsZero，就可以保证 section header 浮在上面。
        self.contentInset = UIEdgeInsetsZero;
    }else{

        // 下拉时， 这两个分支保证在下拉过程及刷新后， section 及 table 能回复到正确位置
        CGFloat sectionHeaderHeight = 64;

        // 下拉刷新结束，scrollView 自动复位，那么此时也立即改变 UIEdgeInsetsMake 以保证 section header 能跟随 scroll view 一起动
        if (self.contentOffset.y < sectionHeaderHeight && self.contentOffset.y >= 0) {
            self.contentInset = UIEdgeInsetsMake(-self.contentOffset.y, 0, 0, 0);
        }

        // 当 table view 恢复到原来的位置，其实 contentInset，contentOffset 已经被我们改变，要恢复到初始状态
        else if (self.contentOffset.y == sectionHeaderHeight) {

            self.contentInset = UIEdgeInsetsZero;
            self.contentOffset = CGPointZero;
        }
    }
}

@end