//
//  WYSegmentView.h
//  GengMei
//
//  Created by wangyang on 13-8-9.
//  Copyright (c) 2015 Gengmei. All rights reserved.
//

#import "GMView.h"

typedef NS_ENUM(NSUInteger, WYSegmentViewWidthStyle) {
    WYSegmentViewWidthStyleFixed, // Segment width is fixed
    WYSegmentViewWidthStyleDynamic, // Segment width will only be as big as the text width (including inset)
};

@interface WYSegmentView : GMView

/**
 *	数组的内容是要显示的 button title，设置该属性后，button 将会被自动添加，详见其 set 方法
 */
@property (nonatomic, strong) NSArray *sectionTitles;

@property (nonatomic, readonly) NSInteger selectedSegmentIndex;

@property (nonatomic, copy) void (^didSelectedBlock)(NSUInteger index);

- (void)layoutSegments;
- (void)setSelectedSegmentIndex:(NSInteger)selectedSegmentIndex animated:(BOOL)animated;
#pragma mark - 自定义UI

// 没有使用 GMScrollView是想把这个 segment view做得更独立一些
@property (nonatomic, readonly) UIScrollView *scrollView;
@property (nonatomic, readonly) UIView *bottomLine;

/**
 *  @author wangyang, 16-02-17 15:02:53
 *
 *  @brief 默认是Dynamic
 *  @since 1.0
 */
@property (nonatomic, assign) WYSegmentViewWidthStyle widthStyle;


/**
 *  @author wangyang, 16-02-15 18:02:32
 *
 *  @brief button之间的间距
 *  @since 1.0
 */
@property (nonatomic, assign) CGFloat innerSpace;

/**
 *  @author wangyang, 16-02-16 10:02:51
 *
 *  @brief button在计算宽度时会将这个这个padding算在内，左右各加一个 itemHorizonalPadding，即buttonWidth = buttonTitleWidth + 2 * itemHorizonalPadding
 *  @since 1.0
 */
@property (nonatomic, assign) CGFloat itemHorizonalPadding;

@property (nonatomic, strong) NSDictionary *titleTextAttributes;
@property (nonatomic, strong) NSDictionary *selectedTitleTextAttributes;

/**
 *  @author wangyang, 16-02-17 11:02:24
 *
 *  @brief 实现这个block，以便继续自定义button的UI。比如添加背景色，边框等
 *  @since 1.0
 */
@property (nonatomic, copy) void (^customButtonUI) (UIButton *button);

/**
 *  @author wangyang, 16-02-15 18:02:19
 *
 *  @brief 是否显示指示器。默认为NO
 *  @since 1.0
 */
@property (nonatomic, assign) BOOL showIndicator;
@property (nonatomic, strong) UIColor *indicatorColor;

/**
 *  @author wangyang, 16-02-17 16:02:38
 *
 *  @brief 默认为0，此时indicator.width与button的标题一样长。
 *  @since 1.0
 */
@property (nonatomic, assign) CGFloat indicatorHorizonalPadding;
/**
 *  @author wangyang, 16-02-17 15:02:17
 *
 *  @brief 自定义 indicator 的位置
 *  @param indicator 指示符
 *  @param button    待指示的button
 *  @since 1.0
 */
@property (nonatomic, copy) void (^customIndicatorConstraint) (UIView *indicator, UIButton *button);

@end
