# GMPhobos

## About The Name 
The name is from the Data Center who named Mars

Phobos (systematic designation: Mars I) is the larger and innermost of the two natural satellites of Mars, the other being Deimos. Both moons were discovered in 1877 by American astronomer Asaph Hall.
Phobos is a small, irregularly shaped object with a mean radius of 11 km (7 mi),[1] and is seven times more massive than Deimos, Mars's outer moon. 
Phobos is named after the Greek god Phobos, a son of Ares (Mars) and Aphrodite (Venus) which was the personification of Horror. 
The name "Phobos" is pronounced /ˈfoʊbəs/ foh-bəs, or like the Greek Φόβος.

## Requirements
Require WMCacheService and libz

## Installation

GMPhobos is available through [CocoaPods](http://cocoapods.org). To install
it, simply add the following line to your Podfile:

```ruby
pod "GMPhobos"
```

Alternatively, you can install manually.  

1 Get the code:

```ruby
git clone git@git.gengmei.cc:gengmeiios/GMPhobos.git
```
  
2 Drag the Phobos subfolder to your project. Check both “copy items into destination group’s folder” and your target.

## Configuration
While you are free to initialize as many instances of Phobos as is appropriate for your application, there is a shared singleton instance that is globally available. 
This singleton instance is often configured in your app delegate’s application:didFinishLaunchingWithOptions: method:

```objc
#import "Phobos.h"

- (BOOL)application:(UIApplication *)application
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
     Phobos *client = [Phobos clientWithAppName:@"appname" channelId:@"appchannel"];
     [Phobos setSharedClient:client];
    /* ... */
    return YES;
}
```

If you would like to specify a user, you can set the userId that is used with the -[setUserId:] Instance method.
```objc
WMUser *user = [[WMLoginManager shareInstance] user];
[client setUserId:user.userId];
```
If you would like to use Phobos, you must set the currentCityId that is used with the -[setCurrentCityId:] Instance method.
```objc
WMCityObject *city = [[WMCacheService sharedInstance] fetchObjectAtDucmentPathWithkey:kCurrentCity];
    if (city) {
        [client setCurrentCityId:city.id];
    }
```

## Sending Messages
Sending a basic message:
```objc
[Phobos track:@"event_id"];
```

Sending a message with another attributes:
```objc
[Phobos track:@"event_id" attributes:@{}];
```

Sending a message with another attributes and send immediately:
```objc
[Phobos track:@"event_id" attributes:@{} sendNow:YES];
```


## Author
Guojun Zhai and Thierry Xing

## License

GMPhobos is available under the MIT license. See the LICENSE file for more info.