//
//  GMPhobosSqulitModel.h
//  GMPhobos
//
//  Created by edz on 2020/6/18.
//

#import <Foundation/Foundation.h>
#import "GMPhobosTool.h"
#import <mach/mach_time.h>

typedef NS_ENUM(int, PhobosDataSendStatus) {
    PhobosDataSendStatus_wait       = 1, // 待发送数据
    PhobosDataSendStatus_send        = 2, // 发送中数据
    PhobosDataSendStatus_finish         = 3, // 发送完成数据
    PhobosDataSendStatus_error          = 4, // 发送失败数据
};


@interface GMPhobosSqulitModel : NSObject

/// 唯一标识(用于筛选)
@property (nonatomic, strong) NSString *message_item_id;
/// 埋点类型
@property (nonatomic, strong) NSString *phobos_type;
/// 内容
@property (nonatomic, strong) NSString *data;
/// 路径
@property (nonatomic, strong) NSString *api;
///插入表格名称
@property (nonatomic, strong) NSString *table_name;
/// 数据状态
@property (nonatomic, assign) PhobosDataSendStatus status;
///是否是立刻发的埋点
@property (nonatomic, assign) BOOL immediately;

+ (GMPhobosSqulitModel *)modelOfDict:(NSDictionary *)data
                       type:(NSString *)phobosType
                     urlApi:(NSString *)urlapi
                  tableName:(NSString *)name
                immediately:(BOOL)status;

@end

