//
//  PhobosDevice.h
//  GMPhobos
//
//  Created by Q14 on 2020/9/22.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef void (^PhobosGetIDFACompleteBlock)(NSDictionary *dict);

@interface PhobosDevice : NSObject

/// 获取IDFA，同步获取 从钥匙串中获取
+ (NSString *)getIDFA;

/// 获取IDFA，异步获取IDFA 适配 ATTrackingManager的时候再打开
//+ (void)getIDFAString:(PhobosGetIDFACompleteBlock)completeBlock;

/// 获取IDFV
+ (NSString *)getIDFV;

/// 获取DEVICEID，先获取idfa 获取不到会获取钥匙串中idfv 如果没有用idfv 生成
+ (NSString *)getDEVICEID;


/// 获取UQID，同步获取取出的是默认第一次的idfv 如果没有用idfv 生成
+ (NSString *)getUQID;

@end

NS_ASSUME_NONNULL_END
