//
//  GMViewController.m
//  GMPhobos
//
//  Created by licong on 01/27/2016.
//  Copyright (c) 2016 licong. All rights reserved.
//

#import "GMViewController.h"
#import <GMPhobos/Phobos.h>
#import <GMCache/GMCache.h>
#import "GMPhobos_Example-Swift.h"

//@import GMCache;
@import GMPhobos.PhobosUtil;
@import GMPhobos.Phobos;
#define PhobosCacheKey @"PhobosCacheKey"

NSString      *const MockAppName      = @"gengmei_test";
NSString      *const MockChannelId    = @"AppStore";
NSString      *const MockEventId      = @"eventId";
NSString      *const MockUserId       = @"1";
NSString      *const MockCityId       = @"beijing";

@interface GMViewController ()<UITableViewDelegate ,UITableViewDataSource>
{
    UITableView *_tableView;
    NSArray *_dataSource;
}

@end

@implementation GMViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    [self sdk];
    
    _dataSource = @[
        @"pageView",
        @"100个线程 * 100数据",
        @"计数发送",
        @"瞬间发送",
        @"瞬间发送和计数发送",
        @"表中有多少条数据",
        @"清空数据"
    ];
    
    _tableView = [[UITableView alloc] initWithFrame:self.view.bounds style:UITableViewStylePlain];
    _tableView.delegate = self;
    _tableView.dataSource = self;
    [_tableView registerClass:[UITableViewCell class] forCellReuseIdentifier:@"cell"];
    [self.view addSubview:_tableView];

}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataSource.count + 100;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"cell"];
    if (indexPath.row < _dataSource.count) {
        cell.textLabel.text = _dataSource[indexPath.row];
    } else {
        cell.textLabel.text = [NSString stringWithFormat:@"%ld", indexPath.row];
    }
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row >= _dataSource.count) return;
    switch (indexPath.row) {
        case 0: //pageView
        {
            for (int i = 0; i < 20; i++) {
                [self pageView:i];
            }
        }
            break;
        case 1://100个线程 * 100数据"
        {
            dispatch_queue_t queue = dispatch_queue_create("lym", DISPATCH_QUEUE_CONCURRENT);
            for (int i = 0; i < 100; i++) {
                dispatch_async(queue, ^{
                    for (int j = 0; j< 100; j++) {
                        [Phobos track:@"100*100" attributes:@{@"index":@(i)} sendNow:NO];
                    }
                });
            }
        }
            break;
        case 2://@"计数发送",
        {
            for (int i = 0; i< 10000; i++) {
                [Phobos track:@"计数发送" attributes:@{@"index":@(i)} sendNow:NO];
            }
            NSLog(@"&&&&&&&&&&&&&&&&&");
        }
            break;
        case 3://@"瞬间发送",
        {
            [Phobos track:@"瞬间发送" attributes:@{@"index":@(0)} sendNow:YES];
        }
            break;
        case 4://瞬间发送和计数发送
        {
            dispatch_async(dispatch_get_global_queue(0, 0), ^{
                for (int i = 0; i< 1000; i++) {
                    [Phobos track:@"瞬间发送和计数发送" attributes:@{@"index":@(i)} sendNow:i % 9];
                }
            });
            
        }
            break;
        case 5://表中有多少条数据
        {
            [Phobos fetchToBeSendPhobosDataCount];
        }
            break;
        case 6://清空数据
        {
            [Phobos removeAllPhobosData];
        }
            break;
            
        default:
            break;
    }
}

-(void)pageView:(int)index {
    NSString *inDate = [PhobosUtil currentTime];
    NSMutableDictionary *dict = [[NSMutableDictionary alloc] init];
    [dict setObject:[PhobosUtil currentTime] forKey:@"out"];
    [dict setObject:inDate forKey:@"in"];
    [dict setObject:@"home" forKey:@"page_name"];
    [dict setObject:@"referrer" forKey:@"referrer"];
    [dict setObject:@"referrer" forKey:@"referrer"];
    [dict setObject:@(0) forKey:@"fake"];
    [dict setObject:@"referrer_id" forKey:@"referrer_id"];
    [dict setObject:@"extra_param" forKey:@"extra_param"];
    [dict setObject:@"referrer_tab_name" forKey:@"referrer_tab_name"];
    [dict setObject:@(0) forKey:@"is_push"];
    [dict setObject:@[@"home", @"search_home"] forKey:@"referrer_link"];
    NSString *name = [NSString stringWithFormat:@"page_view-%d", index];
    [Phobos track:name attributes:dict];

}

- (void)sdk {
    #ifdef POD_CONFIGURATION_APP_STORE
        NSString *url = @"http://log.gmei.com/log/collect";
    #else
        NSString *url = @"http://log.test.igengmei.com/log/collect";
    #endif
        [[NSUserDefaults standardUserDefaults] setBool:YES forKey:PhobosGray];
        Phobos *client = [Phobos clientWithAppName:MockAppName channelId:MockChannelId];
        [Phobos setSharedClient:client];
        Phobos.sharedClient.serverAPI = url;
        [Phobos.sharedClient setLogEnabled:NO]; // 调试打Log模式，看情况开启
        Phobos.sharedClient.signingType = PhobosSigningTypeDebug;
        Phobos.sharedClient.userId = @"";
        Phobos.sharedClient.getTopController = ^UIViewController * _Nonnull{
            return self;
        };
}


@end
