//
//  GMPhobosTool.m
//  GMPhobos
//
//  Created by edz on 2020/6/23.
//

#import "GMPhobosTool.h"

@implementation GMPhobosTool

#pragma mark - 把数组分割成二维数组
+ (NSArray *)splitArray:(NSArray *)array withSubSize:(int)subSize {
    if (subSize < 1) return [NSArray new];
    //  数组将被拆分成指定长度数组的个数
      unsigned long count = array.count % subSize == 0 ? (array.count / subSize) : (array.count / subSize + 1);
      //  用来保存指定长度数组的可变数组对象
      NSMutableArray *arr = [[NSMutableArray alloc] init];
      
     //利用总个数进行循环，将指定长度的元素加入数组
      for (int i = 0; i < count; i ++) {
         //数组下标
         int index = i * subSize;
         //保存拆分的固定长度的数组元素的可变数组
         NSMutableArray *arr1 = [[NSMutableArray alloc] init];
         //移除子数组的所有元素
         [arr1 removeAllObjects];
         
         int j = index;
         //将数组下标乘以1、2、3，得到拆分时数组的最大下标值，但最大不能超过数组的总大小
         while (j < subSize*(i + 1) && j < array.count) {
             [arr1 addObject:[array objectAtIndex:j]];
             j += 1;
         }
         //将子数组添加到保存子数组的数组中
         [arr addObject:[arr1 copy]];
      }
      
      return [arr copy];
}

+ (NSString *)dictionaryToJsonString:(NSDictionary *)dict
{
    NSError *error = nil;
    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:dict options:NSJSONWritingPrettyPrinted error:&error];
    if (error) {
        return nil;
    }
    return [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
}

@end
