//
//  GMExposureModel.h
//  Gengmei
//
//  Created by Mikasa on 2019/6/25.
//  Copyright © 2019 更美互动信息科技有限公司. All rights reserved.
//

// 基于页面的精准曝光Item
@interface GMExposureItemModel : NSObject
/** 记录上滑总次数 */
@property (nonatomic, assign) NSInteger up_slide_times;
/** 记录下滑总次数 */
@property (nonatomic, assign) NSInteger down_slide_times;
/** 记录向上加载总次数 */
@property (nonatomic, assign) NSInteger up_loading_times;
/** 记录向下加载总次数 */
@property (nonatomic, assign) NSInteger down_loading_times;
/** 当前tab_name */
@property (nonatomic, copy) NSString *tab_name;
/** 当前page_name */
@property (nonatomic, copy) NSString *page_name;
/** 当前business_id */
@property (nonatomic, copy) NSString *business_id;
/** 当前referrer */
@property (nonatomic, copy) NSString *referrer;
/** 当前referrer */
@property (nonatomic, copy) NSString *referrerId;
/** 获取上一个页面链路的page_name link  by 7.20.0  如果有此页面有page_name则添加 ， 没有添加"" */
@property (nonatomic, strong) NSArray *referrer_link;
/** 当前filter_f */
@property (nonatomic, copy) NSString *filter_f;
/** 曝光卡片数据 */
@property (nonatomic, strong) NSMutableArray *exposure_cards;
/** 是否精准曝光 */
@property (nonatomic, copy) NSString *is_exposure;

@end


