//
//  Phobos.h
//  GengmeiDoctor
//  Data Statistic Client For Mars
//  Created by Thierry on 16/1/26.
//  Copyright © 2016年 wanmeizhensuo. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PhobosPVProtocol.h"
#import "PhobosConfig.h"
#import <CoreLocation/CLLocation.h>

NS_ASSUME_NONNULL_BEGIN

@interface NewPhobos : NSObject

/**
 *  @brief 开启Phobos统计,默认以BATCH方式发送log.
 *
 *  @param appName  通常由数据端与客户端一起确认的区分不同app的名字
 *  @param channelId 发布渠道
 *
 *  @return Phobos实例
 *
 *  @since 0.0.1
 */
+ (NewPhobos *)clientWithAppName:(NSString *)appName channelId:(NSString *)channelId;

+ (instancetype) alloc __attribute__((deprecated));
- (instancetype) init __attribute__((deprecated));
+ (instancetype) new __attribute__((deprecated));

#pragma mark - SDK配置

+ (instancetype)sharedClient;

/** 用于Phobos库从old更新到new使用，在全量之后删除相关逻辑 */
@property (nonatomic, assign) BOOL isGray;

@property (nonatomic, assign) BOOL isGraySendNow;//控制实时上报

// Phobos在处理业务端传递来的参数时会检查是否某个value为空，如果为空会调用这个block以通知业务层，业务层可以上报这个异常，以助解决问题
@property(nonatomic, copy) void (^captureNullExpection) (NSString *eventId, NSDictionary *info);

/**
 网络状态 wifi=1, mobile=0, 不连通=-1
 */
@property (nonatomic, copy) NSString *netStatus;
/**
 //没有网络连接
 public static final String NETWORN_NONE = "none";
 //wifi连接
 public static final String NETWORN_WIFI = "wifi";
 //手机网络数据连接类型
 public static final String NETWORN_2G = "2G";
 public static final String NETWORN_3G = "3G";
 public static final String NETWORN_4G = "4G";
 public static final String NETWORN_MOBILE = "other";
 */
@property (nonatomic, copy) NSString *networkStatus;

/**
 *  @brief 设置是否打印sdk的log信息,默认不开启
 *
 *  @since 0.0.1
 */
@property (assign, nonatomic) BOOL logEnabled;

/**
 *  @brief 设置当前登录用户的ID，如果没有默认为@""
 *
 *
 *  @since 0.0.2
 */
@property (strong, nonatomic) NSString *userId;

/*!
 *  @author zhaiguojun, 16-05-31
 *
 *  @brief 用户当前的城市id
 *
 *
 *  @since 0.2.7
 */
@property (strong, nonatomic) NSString *currentCityId;

@property (strong, nonatomic) CLLocation *gps;

/**
 * 记录用户类型
 */
@property (strong, nonatomic) NSMutableDictionary *userType;

/**
 数据接收的服务器API
 */
@property (copy, nonatomic) NSString *serverAPI;

/**
 当前APP请求接口的 APIHOST（GMServerDomains.apiHost 主要用于flutter AppDelegate 中初始化需要传值
 */
@property (nonatomic, copy) NSString *apiHost;

/**
 当前APP请求接口的 cookie(主要用于flutter) 获取到cookie 的时候穿过来 或者cookie 有变化的时候传过来
 */
@property (nonatomic, copy) NSString *cookie;

/**
 灰度组, since 7.7.65
 */
@property (nonatomic, copy) NSString *greyType;

/**
 包的类型：APPSTORE、RELEASE、DEBUG
 */
@property (nonatomic, assign) PhobosSigningType signingType;

/**
 从主项目获取当前显示的controller
 */
@property (nonatomic, copy) UIViewController * (^getTopController) (void);

#pragma mark - 事件采集

/** 点击事件采集 */
+ (void)onClickButtonWithAttributes:(NSDictionary *)attributes;
+ (void)onClickButtonWithAttributes:(NSDictionary *)attributes sendNow:(BOOL)sendNow;

/**
 *  @brief 自定义事件,数量统计.
 *
 *  @param eventId 事件Id
 *  @attributes 参数
 *  @sendNow 是否实时发送，默认为NO
 *
 *  @since 0.0.1
 */
+ (void)track:(NSString *)eventName attributes:(NSDictionary *)attributes;
+ (void)track:(NSString *)eventName attributes:(NSDictionary *)attributes sendNow:(BOOL)sendNow;
+ (void)track:(NSString *)eventName;

/**
 *  @brief 自定义事件,数量统计  7730 精准曝光/数据链路.
 *
 *  @param eventId 事件Id
 *  @attributes 参数
 *  @sendNow 是否实时发送，默认为NO
 *  @currentAPI 当前传过来的API
 *  @
 */
+ (void)track:(NSString *)eventName attributes:(NSDictionary *)attributes currentAPI:(NSString *)currentAPI;
+ (void)track:(NSString *)eventName attributes:(NSDictionary *)attributes sendNow:(BOOL)sendNow currentAPI:(NSString *)currentAPI;
+ (void)track:(NSString *)eventName currentAPI:(NSString *)currentAPI;

/**
 *  @brief PV事件开始。当controller viewWillAppear时调用
 */
- (void)onPVStart:(UIResponder<PhobosPVProtocol> *)page;
/**
 *  @brief PV事件结束。当controller viewWillDisAppear时调用
 */
- (void)onPVEnd:(UIResponder<PhobosPVProtocol> *)page;

/**
 * 为隐私弹窗触发on_app_session_over埋点使用
 */
- (void)handleAppInBackgound;

@end

@interface NewPhobos (UtilTest)

/** 获取所有非立即发送埋点数量 */
+ (NSUInteger)fetchToBeSendPhobosDataCount;

/** 清除待发送埋点数据缓存 */
+ (void)removeAllPhobosData;


@end
NS_ASSUME_NONNULL_END
