//
//  PhobosDevice.m
//  GMPhobos
//
//  Created by Q14 on 2020/9/22.
//

#import "PhobosDevice.h"
#import <AdSupport/ASIdentifierManager.h>
#import <SAMKeychain/SAMKeychain.h>
#import <GMCache/GMCache.h>
#import "PhobosUtil.h"
//#import <AppTrackingTransparency/AppTrackingTransparency.h>

NSString *const KprivatePolicyNotification = @"gm_popup_private_policy_notification";
//钥匙串账户
NSString *const keyChainAccount = @"com.wanmeizhensuo.ZhengXing.phobos.keychain";
//钥匙串账户 表示device_id
NSString *const DEVICEID = @"device_id";
//钥匙串账户 表示idfa
NSString *const IDFA = @"idfa";
// 默认获取不到的idfa
NSString *defaultIDFA = @"00000000-0000-0000-0000-000000000000";


static dispatch_queue_t queue;

@implementation PhobosDevice

#pragma mark - getIDFA

//同步获取IDFA 直接从钥匙串中获取 适配ATTrackingManagerAuthorization可使用下面方法
+ (NSString *)getIDFA {
    if (![PhobosDevice showPrivatePolicy]) {
        return defaultIDFA;
    }
    //直接从钥匙串中获取
    NSString *keyChainIDFA = [[ASIdentifierManager sharedManager] advertisingIdentifier].UUIDString;
    if ([self checkIdfaIsNull:keyChainIDFA]) {
        //如果为空从钥匙串中取获取
        keyChainIDFA = [self getKeyChainService:IDFA account:keyChainAccount];
    } else {
        //如果获取到存储到钥匙串中
        [self saveKeyChainWithValue:keyChainIDFA service:IDFA account:keyChainAccount];
    }
    if ([self checkIdfaIsNull:keyChainIDFA]) {
        keyChainIDFA = defaultIDFA;
    }
    return keyChainIDFA;
}

/** iOS 14 适配 ATTrackingManagerAuthorizationStatus
 //同步获取IDFA 直接从钥匙串中获取
+ (NSString *)getIDFA {
    //直接从钥匙串中获取
    NSString *keyChainIDFA = [self getKeyChainService:IDFA account:keyChainAccount];
    //判断获取的钥匙串是否为空
    if ([self checkIdfaIsNull:keyChainIDFA]) {
        if (@available(iOS 14, *)) {
            // 如果是iOS14 未从钥匙串中获取到idfa直接按默认的
            keyChainIDFA = defaultIDFA;
        } else {
            keyChainIDFA = [[ASIdentifierManager sharedManager] advertisingIdentifier].UUIDString;
            if ([self checkIdfaIsNull:keyChainIDFA]) {
                [self saveKeyChainWithValue:keyChainIDFA service:IDFA account:keyChainAccount];
            }
        }
    }
    return keyChainIDFA;
}

//同步获取IDFA
+ (void)getIDFAString:(PhobosGetIDFACompleteBlock)completeBlock {
    if (@available(iOS 14, *)) {
        __block NSString *idfaString = @"";
        [ATTrackingManager requestTrackingAuthorizationWithCompletionHandler:^(ATTrackingManagerAuthorizationStatus status) {
            BOOL isAuthor = NO;
            if (status == ATTrackingManagerAuthorizationStatusAuthorized) {
                isAuthor = YES;
                idfaString = [[ASIdentifierManager sharedManager] advertisingIdentifier].UUIDString;
                
            }
            if (![self checkIdfaIsNull:idfaString]) {
                [self saveKeyChainWithValue:idfaString service:IDFA account:keyChainAccount];
            }
            
            completeBlock(@{@"idfa": idfaString, @"is_author": @(isAuthor)});
        }];
    } else {
        // 使用原方式访问IDFA
        NSString *idfaString = [[[ASIdentifierManager sharedManager] advertisingIdentifier] UUIDString];
        BOOL isAuthor = NO;
        if (![self checkIdfaIsNull:idfaString]) {
            isAuthor = YES;
            [self saveKeyChainWithValue:idfaString service:IDFA account:keyChainAccount];
        }
        
        completeBlock(@{@"idfa": idfaString, @"is_author": @(isAuthor)});
    }
}
*/

#pragma mark - 对IDFA判空处理
//检查idfa 是否为空
+ (BOOL)checkIdfaIsNull:(NSString *)idfa {
    return !idfa.length || [idfa isEqualToString:defaultIDFA];
}


#pragma mark - getIDFV
+ (NSString *)getIDFV {
    if (![PhobosDevice showPrivatePolicy]) {
        return defaultIDFA;
    }
    return [[[UIDevice currentDevice] identifierForVendor] UUIDString];
}


#pragma mark - getDEVICEID
+ (NSString *)getDEVICEID {
    if (![PhobosDevice showPrivatePolicy]) {
        return defaultIDFA;
    }
    NSString *idfa = [self getIDFA];
    if ([self checkIdfaIsNull:idfa]) {
        idfa = [self getUQID];
    }
    return idfa;
}

+ (NSString *)getUQID {
    if (![PhobosDevice showPrivatePolicy]) {
        return defaultIDFA;
    }
    NSString *deviceId = [self getKeyChainService:DEVICEID account:keyChainAccount];
    if ([self checkIdfaIsNull:deviceId]) {
        deviceId = [self getIDFV];
        [self saveKeyChainWithValue:deviceId service:DEVICEID account:keyChainAccount];
    }
    return deviceId;
}


#pragma mark - 钥匙串封装
+ (void)saveKeyChainWithValue:(NSString *)value service:(NSString *)service account:(NSString *)account {
    //避免在重复相同的key 重复设置
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        queue = dispatch_queue_create("com.device.idfa.serial.queue", DISPATCH_QUEUE_SERIAL);
    });
    
    if (queue && [PhobosUtil isNonEmpty:service] && ![self checkIdfaIsNull:value]) {
        dispatch_sync(queue, ^{
            [SAMKeychain setPassword:value forService:service account:account];
            [SAMKeychain setAccessibilityType:kSecAttrAccessibleAlwaysThisDeviceOnly];
        });
    }
}

//根据 service 与账户keyChain 获取存储的值
+ (NSString *)getKeyChainService:(NSString *)service account:(NSString *)account {
    return [SAMKeychain passwordForService:service account:account];
}

+ (BOOL)showPrivatePolicy {
    return [GMCache fetchObjectAtDocumentPathWithkey:KprivatePolicyNotification];
}

@end
