//
//  UIResponder+PhobosPV.m
//  Pods
//
//  Created by wangyang on 2017/2/7.
//
//

#import "UIResponder+PhobosPV.h"
#import <objc/runtime.h>
#import "PhobosUtil.h"

@implementation UIResponder (PhobosPV)

/**
 *  @author 翟国钧, 16-03-01 15:03:24
 *
 *  @brief 取当前导航栈中当前VC的上级VC，如果该VC存在，就获取他的pageName
 *
 *  @since 5.9.1
 */
- (void)initReferer {
    // 只有不为空，且是controller的情况下才自动获取
    if ([self.referer isEqualToString:@""] && [self isKindOfClass:[UIViewController class]]) {
        // 分present与navigation两种情况
        UIViewController *me = (UIViewController *)self;
        if (me.presentingViewController != nil) {
            // app全局只有一个navigation，发现此时用navigation.topViewController presentViewController时，最终使用的是navigation弹出的
            // 所以此处要判断，如果是navigation弹出，最后还是要定位到topViewController
            if ([me.presentingViewController isKindOfClass:[UINavigationController class]]) {
                UIViewController *top = ((UINavigationController *)me.presentingViewController).topViewController;
                self.referer = top.pageName;
            } else {
                self.referer = me.presentingViewController.pageName;
            }
        } else {
            NSArray *navigationPool = ((UIViewController *)self).navigationController.viewControllers;
            NSInteger refererIndex = navigationPool.count - 2;
            if (refererIndex < 0 ) {
                return ;
            }
            UIViewController *controller = navigationPool[refererIndex];
            self.referer = controller.pageName;
        }
    }
}

// 适用于链路中页面浏览事件的统计 添加 refererLink 参数
- (void)initRefererLink {
    // 添加 self.referrerLink.count == 0 ，处理referrerLink有值，就不需要初始化，为后期push、UniversalLinks修改referrerLink进行扩展，否则会重新被赋值
    if (self.referrerLink.count == 0 && [self isKindOfClass:[UIViewController class]]) {
        // 分present与navigation两种情况
        UIViewController *me = (UIViewController *)self;
        if (me.isPush) { // 如果是推送进来的，结果页面的referrerLink 为”push“ 此处添加过滤。
            self.referrerLink = @[@"push"];
        } else if (me.presentingViewController != nil) {
            // app全局只有一个navigation，发现此时用navigation.topViewController presentViewController时，最终使用的是navigation弹出的
            // 所以此处要判断，如果是navigation弹出，最后还是要定位到topViewController
            if ([me.presentingViewController isKindOfClass:[UINavigationController class]]) {
                UIViewController *top = ((UINavigationController *)me.presentingViewController).topViewController;
                NSMutableArray *tempLink = [NSMutableArray arrayWithArray:top.referrerLink];
                [tempLink addObject:top.pageName];
                self.referrerLink = tempLink;
            } else {
                NSMutableArray *tempLink = [NSMutableArray arrayWithArray:me.presentingViewController.referrerLink];
                [tempLink addObject:me.presentingViewController.pageName];
                self.referrerLink = tempLink;
            }
        } else {
            NSArray *navigationPool = ((UIViewController *)self).navigationController.viewControllers;
            NSInteger refererIndex = navigationPool.count - 2;
            if (refererIndex >= 0 ) {
                UIViewController *controller = navigationPool[refererIndex];
                NSMutableArray *tempLink = [NSMutableArray arrayWithArray:controller.referrerLink];
                [tempLink addObject:controller.pageName];
                self.referrerLink = tempLink;
            }
        }
    }
}

- (void)setReferrerLink:(NSArray *)referrerLink {
    objc_setAssociatedObject(self, @selector(referrerLink), referrerLink, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}


-(NSArray *)referrerLink {
    NSArray *referrerLink = objc_getAssociatedObject(self, @selector(referrerLink));
    return referrerLink ?: @[];
}

/**
 此方法在onPvStart时调用，给referrerTabName赋值
 */
- (void)initReferrerTabName {
    // 只有是controller的情况下才自动获取
    if ([self.referrerTabName isEqualToString:@""] && [self isKindOfClass:[UIViewController class]]) {
        // 分present与navigation两种情况
        UIViewController *me = (UIViewController *)self;
        if (me.presentingViewController != nil) {
            // app全局只有一个navigation，发现此时用navigation.topViewController presentViewController时，最终使用的是navigation弹出的
            // 所以此处要判断，如果是navigation弹出，最后还是要定位到topViewController
            if ([me.presentingViewController isKindOfClass:[UINavigationController class]]) {
                UIViewController *top = ((UINavigationController *)me.presentingViewController).topViewController;
                self.referrerTabName = top.tabName;
            } else {
                self.referrerTabName = me.presentingViewController.tabName;
            }
        } else {
            NSArray *navigationPool = ((UIViewController *)self).navigationController.viewControllers;
            NSInteger refererIndex = navigationPool.count - 2;
            if (refererIndex < 0 ) {
                return ;
            }
            UIViewController *controller = navigationPool[refererIndex];
            self.referrerTabName = controller.tabName;
        }
    }
}

- (void)setReferer:(NSString *)referer {
    objc_setAssociatedObject(self, @selector(referer), referer, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (NSString *)referer
{
    NSString *referer = objc_getAssociatedObject(self, @selector(referer));
    return referer == nil ? @"" : referer;
}

- (NSString *)pageName {
    NSString *name = objc_getAssociatedObject(self, @selector(pageName));
    return name == nil ? @"" : name;
}

- (void)setPageName:(NSString *)pageName {
    objc_setAssociatedObject(self, @selector(pageName), pageName, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (NSString *)businessId {
    NSString *businessId = objc_getAssociatedObject(self, @selector(businessId));
    return businessId == nil ? @"" : businessId;
}

- (void)setBusinessId:(NSString *)businessId {
    objc_setAssociatedObject(self, @selector(businessId), businessId, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (void)setInTime:(NSString *)inTime {
    objc_setAssociatedObject(self, @selector(inTime), inTime, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

/**
 这个地方inTime的值为nil的情况不做考虑,因为Phobos不会发送。inTime必须在controller viewWillAppear时赋值
 */
- (NSString *)inTime {
    NSString *inTime = objc_getAssociatedObject(self, @selector(inTime));
    return inTime;
}

- (void)setInTimeMillis:(NSString *)inTimeMillis {
    objc_setAssociatedObject(self, @selector(inTimeMillis), inTimeMillis, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (NSString *)inTimeMillis {
    NSString *inTimeMillis = objc_getAssociatedObject(self, @selector(inTimeMillis));
    return inTimeMillis;
}

- (void)initReferrerIdIfNil {
     // 只有不为空，且是controller的情况下才自动获取
    if ([self.referrerId isEqualToString:@""] && [self isKindOfClass:[UIViewController class]]) {
        // 分present与navigation两种情况
        UIViewController *me = (UIViewController *)self;
        if (me.presentingViewController != nil) {
            objc_setAssociatedObject(self, @selector(referrerId), me.presentingViewController.businessId, OBJC_ASSOCIATION_COPY);
        } else {
            NSArray *navigationPool = ((UIViewController *)self).navigationController.viewControllers;
            NSInteger refererIdIndex = navigationPool.count - 2;
            if (refererIdIndex < 0) {
                self.referrerId = @"";
            } else {
                UIViewController *controller = navigationPool[refererIdIndex];
                self.referrerId = controller.businessId;
            }
        }
    }
}

- (void)setReferrerId:(NSString *)referrerId {
    objc_setAssociatedObject(self, @selector(referrerId), referrerId, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (NSString *)referrerId {
    NSString *referrerId = objc_getAssociatedObject(self, @selector(referrerId));
    return referrerId == nil ? @"" : referrerId;
}

- (BOOL)needLogPV {
    NSNumber *needLogPV = objc_getAssociatedObject(self, @selector(needLogPV));
    return needLogPV == nil ? YES : needLogPV.boolValue;
}

- (void)setNeedLogPV:(BOOL)needLogPV {
    objc_setAssociatedObject(self, @selector(needLogPV), @(needLogPV), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (void)setExtraParam:(NSString *)extraParam {
    objc_setAssociatedObject(self, @selector(extraParam), extraParam, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (NSString *)extraParam {
    NSString *extraParam = objc_getAssociatedObject(self, @selector(extraParam));
    return extraParam == nil ? @"" : extraParam;
}

- (void)setTabName:(NSString *)tabName {
    objc_setAssociatedObject(self, @selector(tabName), tabName, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (NSString *)tabName {
    NSString *tabName = objc_getAssociatedObject(self, @selector(tabName));
    return tabName == nil ? @"" : tabName;
}

- (void)setReferrerTabName:(NSString *)referrerTabName {
    objc_setAssociatedObject(self, @selector(referrerTabName), referrerTabName, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (NSString *)referrerTabName {
    NSString *referrerTabName = objc_getAssociatedObject(self, @selector(referrerTabName));
    return referrerTabName == nil ? @"" : referrerTabName;
}

- (void)setIsPush:(BOOL)isPush {
    objc_setAssociatedObject(self, @selector(isPush), @(isPush), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (BOOL)isPush {
    NSNumber *isPush = objc_getAssociatedObject(self, @selector(isPush));
    return isPush == nil ? NO : isPush.boolValue;
}

- (void)setMessageId:(NSString *)messageId {
    objc_setAssociatedObject(self, @selector(messageId), messageId, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (NSString *)messageId {
    NSString *messageId = objc_getAssociatedObject(self, @selector(messageId));
    return messageId == nil ? @"" : messageId;
}

- (void)setUpdatePVStartBlock:(PhobosUpdatePVBlock)updatePVStartBlock {
    objc_setAssociatedObject(self, @selector(updatePVStartBlock), updatePVStartBlock, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (void)setIsFirstEntry:(BOOL)isFirstEntry {
    objc_setAssociatedObject(self, @selector(isFirstEntry), @(isFirstEntry), OBJC_ASSOCIATION_ASSIGN);
}

-(BOOL)isFirstEntry {
    NSNumber *num = objc_getAssociatedObject(self, _cmd);
    return [num boolValue];
}

- (PhobosUpdatePVBlock)updatePVStartBlock {
    PhobosUpdatePVBlock updatePVBlock = objc_getAssociatedObject(self, @selector(updatePVStartBlock));
    return updatePVBlock;
}

- (void)setUpdatePVEndBlock:(PhobosUpdatePVBlock)updatePVEndBlock {
    objc_setAssociatedObject(self, @selector(updatePVEndBlock), updatePVEndBlock, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (PhobosUpdatePVBlock)updatePVEndBlock {
    PhobosUpdatePVBlock updatePVBlock = objc_getAssociatedObject(self, @selector(updatePVEndBlock));
    return updatePVBlock;
}

- (void)setSourceFromPushWithMessageId:(NSString *)messageId {
    self.isPush = YES;
    self.messageId = messageId;
}
@end
