//
//  GMExposureProtocol.h
//  Gengmei
//
//  Created by Mikasa on 2019/6/21.
//  Copyright © 2019 更美互动信息科技有限公司. All rights reserved.
//



typedef NS_ENUM(NSInteger, GMViewExpoStatus) {
    GMViewExpoStatusNone    = 0,// 无状态
    GMViewExpoStatusStart   = 1,// 开始曝光
    GMViewExpoStatusIng     = 2,// 正在曝光(暂未使用，暂时先保留)
    GMViewExpoStatusEnd     = 3 // 结束曝光
};

@protocol GMViewExposureProtocol <NSObject>
@property (nonatomic, weak) UIViewController *pageCtrl;// 当前viewz所在页面
/** view别名 */
@property (nonatomic, copy) NSString *viewName;
/** view别名 */
@property (nonatomic, copy) NSString *inTime;
/** view别名 */
@property (nonatomic, copy) NSString *outTime;
/** 绝对位置 */
@property (nonatomic, copy) NSString *absolute_position;
/** 相对位置(相对屏幕所在位置)*/
@property (nonatomic, copy) NSString *relative_position;
/** 额外参数*/
@property (nonatomic, strong) NSDictionary *extra_param;
/** 曝光状态 */
@property (nonatomic, assign) GMViewExpoStatus expoStatus;

@end

@protocol GMPageExposureProtocol <NSObject>

/**
 * 是否获取到数据立即发送，YES的话不会进行去重逻辑，需要数据去重
 */
@property (nonatomic, assign) BOOL needImmediatelySend;

@property (nonatomic, assign) BOOL needExpo;// 页面需要精准曝光

/** 记录上滑总次数 */
@property (nonatomic, assign) NSInteger up_slide_times;
/** 记录下滑总次数 */
@property (nonatomic, assign) NSInteger down_slide_times;
/** 记录向上加载总次数 */
@property (nonatomic, assign) NSInteger up_loading_times;
/** 记录向下加载总次数 */
@property (nonatomic, assign) NSInteger down_loading_times;
/** 额外参数 */
@property (nonatomic, strong) NSDictionary *extra_param;

@end



@protocol GMExposureProtocol <NSObject>

/** 精准曝光数据 */
@property (nonatomic, strong) NSDictionary *exposure;

@end
