//
//  NSObject+Tracker.m
//  GMPhobos
//
//  Created by Mikasa on 2020/5/9.
//

#import "NSObject+Tracker.h"
#import "UIResponder+PhobosPV.h"
#import <objc/runtime.h>
@implementation NSObject (Tracker)

/// 获取通用数据
/// @param responder 当前responder
+ (NSDictionary *)trackerPageParam:(UIResponder *)responder {
    NSArray *referrerLink = responder.referrerLink;
        
    NSDictionary *params = @{@"page_name" : responder.pageName?:@"",
                             @"business_id" : responder.businessId?:@"",
                             @"tab_name" : responder.tabName?:@"",
                             @"referrer_tab_name" : responder.referrerTabName?:@"",
                             @"referrer_id" : responder.referrerId?:@"",
                             @"referrer" : responder.referer?:@""};
    NSMutableDictionary *paramsM = [NSMutableDictionary dictionaryWithDictionary:params];
    if (referrerLink.count) {
        [paramsM addEntriesFromDictionary:@{@"referrer_link" : referrerLink}];
    };
    
    return paramsM;
}

/// 进行数据同步
/// 将当前UIResponder 上通用数据同步给 response
/// @param response 需要进行同步的response
- (void)synchronizePVData:(UIResponder *)response toResponse:(UIResponder *)toResponse {
    
    if (!toResponse || !response) {
        return;
    }
    toResponse.pageName = response.pageName?:@"";
    toResponse.tabName = response.tabName?:@"";
    toResponse.referrerTabName = response.referrerTabName?:@"";
    toResponse.businessId = response.businessId?:@"";
    toResponse.referer = response.referer?:@"";
    toResponse.referrerId = response.referrerId?:@"";
    toResponse.referrerLink = response.referrerLink;
}

#pragma mark - Exposure
- (void)setExposure:(NSDictionary *)exposure {
    
    objc_setAssociatedObject(self, @selector(exposure), exposure, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (NSDictionary *)exposure {
    return objc_getAssociatedObject(self, @selector(exposure));
}

@end
