//
//  UIScrollView+Tracker.m
//  Gengmei
//
//  Created by Mikasa on 2019/6/19.
//  Copyright © 2019 更美互动信息科技有限公司. All rights reserved.
//

#import "UIScrollView+Tracker.h"
#import "UIViewController+Tracker.h"
#import "NSObject+Swizzle.h"
#import "GMExposureManager.h"
#import <objc/runtime.h>

@implementation UIScrollView (Tracker)

- (void)calculateUpOrDownTimes {
    
    if (self.preContentOffsetY == self.contentOffset.y) {
        return;
    }
    // 判断滚动方向
    if (self.preContentOffsetY < self.contentOffset.y) {
        self.pageCtrl.up_slide_times++;
    } else {
        self.pageCtrl.down_slide_times++;
    }
}

#pragma mark - Add Method
- (void)setPreContentOffsetY:(CGFloat)preContentOffsetY {
    
    objc_setAssociatedObject(self, @selector(preContentOffsetY), @(preContentOffsetY), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (CGFloat)preContentOffsetY {
    return [objc_getAssociatedObject(self, @selector(preContentOffsetY)) floatValue];
}

@end

@implementation UITableView (Tracker)

+ (void)load {
    [self swizzleInstanceMethod:@selector(reloadData) withSelector:@selector(swizzle_reloadData)];
}

- (void)swizzle_reloadData {

    [self swizzle_reloadData];

    if (self.pageCtrl.needExpo) {
        __weak typeof(self)weakSelf = self;
        dispatch_async(dispatch_get_main_queue(), ^{
            [GMExposureManager fetchViewForVisibleState:weakSelf
                                            trackerType:GMViewTrackerTypeUIViewSetExposure recursive:YES];
        });
    }
}

@end

@implementation UICollectionView (Tracker)

+ (void)load {
    [self swizzleInstanceMethod:@selector(reloadData) withSelector:@selector(swizzle_reloadData)];
}

- (void)swizzle_reloadData {
    
    [self swizzle_reloadData];

    if (self.pageCtrl.needExpo) {
        __weak typeof(self)weakSelf = self;
        dispatch_async(dispatch_get_main_queue(), ^{
            [GMExposureManager fetchViewForVisibleState:weakSelf
                                            trackerType:GMViewTrackerTypeUIViewSetExposure recursive:YES];
        });
    }
}

@end




