//
//  UIView+Tracker.h
//  Gengmei
//
//  Created by Mikasa on 2019/6/21.
//  Copyright © 2019 更美互动信息科技有限公司. All rights reserved.
//

#import "GMExposureProtocol.h"
#import "GMTrackerProtocol.h"

@interface UIView (Tracker)<GMCpcProtocol, GMViewExposureProtocol>

@property (nonatomic, assign) BOOL visibleView;// 是否是可见View

#pragma mark - View Method
/**
 获取指定View所在的Controller

 @param view 指定View
 @return 当前所在Controller
 */
+ (UIViewController *)currentControllerForView:(UIView *)view;

/// 判断当前view是否处于屏幕上
/// @param view 指定view
+ (BOOL)viewIsVisible:(UIView *)view;
/**
 获取曝光卡片所在的位置
*/
- (void)fechExposurePositionForView;

- (void)synchronizePageTimesToOther:(UIView *)otherView;
@end
