//
//  UIView+Tracker.m
//  Gengmei
//
//  Created by Mikasa on 2019/6/21.
//  Copyright © 2019 更美互动信息科技有限公司. All rights reserved.
//

#import "UIView+Tracker.h"
#import "UIViewController+Tracker.h"
#import "NSObject+Swizzle.h"
#import "PhobosUtil.h"
#import "GMExposureModel.h"
#import <objc/runtime.h>

@implementation UIView (Tracker)

#pragma mark - View Method
/**
 获取指定View所在的Controller
 
 @param view 指定View
 @return 当前所在Controller
 */
+ (UIViewController *)currentControllerForView:(UIView *)view {
    
    UIViewController *currentCtrl;
    UIResponder *responder = [view.superview nextResponder];
    while (responder && ![responder isKindOfClass:[UIViewController class]]) {
        responder = [responder nextResponder];
    }
    currentCtrl = (UIViewController *)responder;
    return currentCtrl;
}

/**
 获取曝光卡片所在的位置
 */
- (void)fechExposurePositionForView {
    
        UIView *view = self;
        NSInteger absolute_position = [PhobosUtil isNonEmpty:self.absolute_position]?self.absolute_position.integerValue : 0;
        UIView *current = (UIView *)view;
        UIView *tempView = view;
        
        while ([current isKindOfClass:[UIView class]] && (current != view.pageCtrl.view)) {
            
            if ([current isKindOfClass:[UITableViewCell class]]) {
                tempView = current;
            }
            if ([current isKindOfClass:[UICollectionViewCell class]]) {
                tempView = current;
            }
            if ([current isKindOfClass:[UITableView class]]) {
                UITableView *tableView = (UITableView *)current;
                UITableViewCell *cell = (UITableViewCell *)tempView;
                
                if ([tableView.visibleCells containsObject:cell]) {
                    NSIndexPath *indexPath = [tableView indexPathForCell:cell];
                    if (indexPath) {
                        // 当有多个分组时，将position转化为绝对路径的position，一维数组
                        if (tempView == view) {
                            absolute_position = indexPath.row;
                            for (NSInteger i = 0; i < indexPath.section; i++)  {
                                absolute_position += [tableView numberOfRowsInSection:i];
                            }
                        }
                        NSInteger relative_position = 0;
                        if ([[tableView visibleCells] containsObject:cell]) {
                            relative_position = [[tableView visibleCells] indexOfObject:cell];
                            view.relative_position = [NSString stringWithFormat:@"%zd",relative_position];
                            break;
                        }
                    }
                }
            }
            if ([current isKindOfClass:[UICollectionView class]]) {
                UICollectionView *collectionView = (UICollectionView *)current;
                UICollectionViewCell *cell = (UICollectionViewCell *)tempView;
                if ([collectionView.visibleCells containsObject:cell]) {
                    NSIndexPath *indexPath = [collectionView indexPathForCell:cell];
                    if (indexPath) {
                        // 当有多个分组时，将position转化为绝对路径的position，一维数组
                        if (tempView == view) {
                            absolute_position = indexPath.row;
                            for (NSInteger i = 0; i < indexPath.section; i++) {
                                absolute_position += [collectionView numberOfItemsInSection:i];
                            }
                        }
                        
                        NSInteger relative_position = 0;
                        // UICollectionViewCell
                        if ([[collectionView visibleCells] containsObject:cell]) {
                            relative_position = [[collectionView visibleCells] indexOfObject:cell];
                            view.relative_position = [NSString stringWithFormat:@"%zd",relative_position];
                            break;
                            //NSLog(@"%f---%f",relative_position,absolute_position);
                        }
                    }
                }
                
            }
            current = (UITableViewCell *)current.superview;
        }
        view.absolute_position = [NSString stringWithFormat:@"%zd",absolute_position];
}

// 将当前UIScrollView数据同步给另外一个otherScrollView
- (void)synchronizePageTimesToOther:(UIView *)otherView {
    
    otherView.pageCtrl.up_slide_times = self.pageCtrl.up_slide_times;
    otherView.pageCtrl.down_slide_times = self.pageCtrl.down_slide_times;
    otherView.pageCtrl.up_loading_times = self.pageCtrl.up_loading_times;
    otherView.pageCtrl.down_loading_times = self.pageCtrl.down_loading_times;
}

/// 判断当前view是否处于屏幕上
/// @param view 指定view
+ (BOOL)viewIsVisible:(UIView *)view {
    // 可见
    if (!view.window || view.hidden || view.layer.hidden || !view.alpha) {
        
        return NO;
    }
    
    UIView *current = view;
    while ([current isKindOfClass:[UIView class]]) {
        if (current.alpha <= 0 || current.hidden) {
            return NO;
        }
        current = current.superview;
    }
    
    // 判断当前View 与 view所在window是否存在交集
    CGRect viewRectInWindow = [view convertRect:view.bounds toView:view.window];
    BOOL isIntersects = CGRectIntersectsRect(view.window.bounds, viewRectInWindow);
    
    if (isIntersects) {
        // 获取View 与 view所在window的相交区域
        CGRect intersectRect = CGRectIntersection(view.window.bounds, viewRectInWindow);
        if (intersectRect.size.width != 0.f && intersectRect.size.height != 0.f) {
            return YES;
        }
    }
    return NO;
}

#pragma mark - GMViewExposureProtocol
- (void)setVisibleView:(BOOL)visibleView {
    
    objc_setAssociatedObject(self, @selector(visibleView), @(visibleView), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (BOOL)visibleView {
    return [objc_getAssociatedObject(self, @selector(visibleView)) boolValue];
}

- (void)setInTime:(NSString *)inTime {
    objc_setAssociatedObject(self, @selector(inTime), inTime, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (NSString *)inTime {
    return objc_getAssociatedObject(self, @selector(inTime));
}

- (void)setOutTime:(NSString *)outTime {
    objc_setAssociatedObject(self, @selector(outTime), outTime, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (NSString *)outTime {
    return objc_getAssociatedObject(self, @selector(outTime));
}

- (void)setAbsolute_position:(NSString *)absolute_position {
    objc_setAssociatedObject(self, @selector(absolute_position), absolute_position, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (NSString *)absolute_position {
    return objc_getAssociatedObject(self, @selector(absolute_position));
}

- (void)setRelative_position:(NSString *)relative_position {
    objc_setAssociatedObject(self, @selector(relative_position), relative_position, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (NSString *)relative_position {
    return objc_getAssociatedObject(self, @selector(relative_position));
}

- (void)setPageCtrl:(UIViewController *)pageCtrl {
    GMWeakObject *obj = [[GMWeakObject alloc] initWithObj:pageCtrl];
    objc_setAssociatedObject(self, @selector(pageCtrl), obj, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (UIViewController *)pageCtrl {
    
    GMWeakObject *weakObj = objc_getAssociatedObject(self, @selector(pageCtrl));
    if (!weakObj.obj) {
        weakObj.obj = [UIView currentControllerForView:self];
    }
    return weakObj.obj;
}

- (void)setViewName:(NSString *)viewName {
    objc_setAssociatedObject(self, @selector(viewName), viewName, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (NSString *)viewName {
    return objc_getAssociatedObject(self, @selector(viewName));
}

- (void)setExpoStatus:(GMViewExpoStatus)expoStatus {
    
    objc_setAssociatedObject(self, @selector(expoStatus), @(expoStatus), OBJC_ASSOCIATION_RETAIN_NONATOMIC);

    if (expoStatus == GMViewExpoStatusStart) {
        
    } else if (expoStatus == GMViewExpoStatusEnd) {
        self.inTime = @"";
        self.outTime = @"";
        self.relative_position = @"";
        self.absolute_position = @"";
    }
}

- (GMViewExpoStatus)expoStatus {
    return [objc_getAssociatedObject(self, @selector(expoStatus)) integerValue];
}

- (void)setExtra_param:(NSDictionary *)extra_param {
    objc_setAssociatedObject(self, @selector(extra_param), extra_param, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (NSDictionary *)extra_param {
    return objc_getAssociatedObject(self, @selector(extra_param));
}
@end
