//
//  GMPhobosPageViewModel.m
//  GMPhobos
//
//  Created by edz on 2020/6/22.
//


#import "GMPhobosPageViewModel.h"

@implementation GMPhobosPageViewModel


+ (GMPhobosPageViewModel *)pageViewModelOfDict:(NSDictionary *)dict
                                  type:(NSString *)phobosType
                                urlApi:(NSString *)urlapi
                             tableName:(NSString *)name
                           immediately:(BOOL)status {
    GMPhobosPageViewModel *model = [[GMPhobosPageViewModel alloc] init];
    //共有参数
    model.table_name = name;
    NSTimeInterval time = [[NSDate date] timeIntervalSince1970] * 1000;
    model.message_item_id = [NSString stringWithFormat:@"%.f/%lld", time, mach_absolute_time()];
    NSMutableDictionary *messageDict = [NSMutableDictionary dictionaryWithDictionary:dict];
    [messageDict setValue:model.message_item_id forKey:@"message_item_id"];
    model.data = [GMPhobosTool dictionaryToJsonString:messageDict];
    model.status = PhobosDataSendStatus_wait;
    model.phobos_type = phobosType;
    model.api = urlapi;
    model.immediately = status;
    //私有参数
    NSDictionary *data = dict[@"params"];
    model.gm_out = data[@"out"];
    model.gm_in = data[@"in"];
    model.gm_page_name = data[@"page_name"];
    model.gm_business_id = data[@"business_id"];
    model.gm_referrer = data[@"referrer"];
    model.gm_referrer_link = data[@"referrer_link"];
    model.gm_referrer_id = data[@"referrer_id"];
    model.gm_extra_param = data[@"extra_param"];
    model.gm_referrer_tab_name = data[@"referrer_tab_name"];
    model.gm_is_push = data[@"is_push"];
    model.gm_message_id = data[@"message_id"];
    model.gm_in_time_millis= data[@"in_time_millis"];
    model.gm_out_time_millis = data[@"out_time_millis"];
    model.gm_is_first = data[@"is_first"];
    
    return model;
}
@end
