//
//  GMPhobosSqulitModel.m
//  GMPhobos
//
//  Created by edz on 2020/6/18.
//

#import "GMPhobosSqulitModel.h"


@implementation GMPhobosSqulitModel

+ (GMPhobosSqulitModel *)modelOfDict:(NSDictionary *)data
                       type:(NSString *)phobosType
                     urlApi:(NSString *)urlapi
                  tableName:(NSString *)name
                immediately:(BOOL)status{
    GMPhobosSqulitModel *model = [GMPhobosSqulitModel new];
    model.table_name = name;
    NSTimeInterval time = [[NSDate date] timeIntervalSince1970] * 1000;
    model.message_item_id = [NSString stringWithFormat:@"%.f/%lld", time, mach_absolute_time()];
    NSMutableDictionary *dict = [NSMutableDictionary dictionaryWithDictionary:data];
    [dict setValue:model.message_item_id forKey:@"message_item_id"];
    model.data = [GMPhobosTool dictionaryToJsonString:dict];
    model.status = PhobosDataSendStatus_wait;
    model.phobos_type = phobosType;
    model.api = urlapi;
    model.immediately = status;
    return model;
}


@end
