//
//  NSDate+DateFormat.m
//  Gengmei
//
//  Created by Sean Lee on 4/14/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "NSDate+DateFormat.h"

@implementation NSDate (DateFormat)

-(NSString *)dateFormatToString {
    
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    [formatter setDateFormat:@"yyyy-MM-dd"];
    return [formatter stringFromDate:self];
}


- (NSString *)dateFormatToWeekString{
    
    NSCalendar *calendar = [NSCalendar currentCalendar];
    NSDateComponents *comps;
    comps = [calendar components:(NSYearCalendarUnit | NSMonthCalendarUnit | NSDayCalendarUnit | NSWeekdayCalendarUnit) fromDate:self];
    NSInteger nowYear = [comps year];
    NSInteger nowMonth = [comps month];
    NSInteger nowDay = [comps day];
    NSInteger nowWeek = [comps weekday];
    NSString *weekStr = [[NSString alloc] init];
    switch (nowWeek) {
        case 1:
            weekStr = @"星期天";
            break;
        case 2:
            weekStr = @"星期一";
            break;
        case 3:
            weekStr = @"星期二";
            break;
        case 4:
            weekStr = @"星期三";
            break;
        case 5:
            weekStr = @"星期四";
            break;
        case 6:
            weekStr = @"星期五";
            break;
        case 7:
            weekStr = @"星期六";
            break;
            
        default:
            break;
    }
    NSString * formatterDateString =  [NSString stringWithFormat:@"%ld年%ld月%ld日",(long)nowYear,(long)nowMonth,(long)nowDay];
    return formatterDateString;

    
}


@end
