//
//  GMDatePicker.h
//  ZhengXing
//
//  Created by Sean Lee on 11/19/14.
//  Copyright (c) 2014 Wanmei Creative. All rights reserved.
//

#import <UIKit/UIKit.h>

@protocol GMDatePickerDelegate <NSObject>

/**
 *  @author licong, 16-01-08 15:01:24
 *
 *  弹出DatePicker
 *
 *  @since 5.8.0
 */
- (void)openPicker;

@end


@interface GMDatePickerView : UIView<UIGestureRecognizerDelegate>

@property (nonatomic, strong) UIView * contentView;
@property (nonatomic, strong) UIDatePicker *picker;
@property (nonatomic, assign) id<GMDatePickerDelegate> delegate;
@property (nonatomic, strong) NSString * leftButtonTitle;
@property (nonatomic, strong) NSString * titleLabelTitle;
@property (nonatomic, copy)   void (^ confirmButtonClickBolck) (NSDate  * selecteDate);

-(void)show;

-(void)hide;

@end
