//
//  GMPlaceholderTextContainer.h
//  Gengmei
//
//  Created by wangyang on 16/1/5.
//  Copyright © 2016年 Wanmeichuangyi. All rights reserved.
//

#import "GMView.h"
#import "GMLabel.h"

/**
 *  @author wangyang, 16-01-05 14:01:02
 *
 *  @brief 提供一个有placeholderLable的textView。因为直接在UITextView上添加subview可能会导致crash（这应该是SDK的bug），在高版本sdk不会crash，所以只能提供这样一个view，分别包含UITextVie和Label
 *  @since 5.8.0
 */
@interface GMPlaceholderTextContainer : GMView
@property (nonatomic, strong) GMLabel *placeholderLabel;
@property (nonatomic, strong) UITextView *textView;

@property (nonatomic, assign) CGPoint placeholderOrigin;

// 等于 textView.text
@property (nonatomic, copy) NSString *text;

// 等于 placeholderLabel.text
@property (nonatomic, copy) NSString *placeholder;

// 等于 textView.resignFirstResponder
- (BOOL)resignFirstResponder;

// 等于 textView.becomeFirstResponder
- (BOOL)becomeFirstResponder;

@end
