//
//  PreviewCell.m
//  Gengmei
//
//  Created by Sean Lee on 4/7/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "GMPreviewCell.h"
#import <Masonry/Masonry.h>

@implementation GMPreviewCell

- (id)initWithFrame:(CGRect)frame image:(UIImage *)image
{
    self = [super initWithFrame:frame];
    if (self) {
        
        _image = image;
        self.retryButton = [GMButton buttonWithType:UIButtonTypeCustom];
        [self addSubview:self.retryButton];
        [self.retryButton setImage:[UIImage imageNamed:@"Refresh"] forState:UIControlStateNormal];
        [self.retryButton addTarget:self action:@selector(retryAction:) forControlEvents:UIControlEventTouchUpInside];
        [self.retryButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.center.equalTo(self);
        }];
        
        self.indicatorView = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleWhiteLarge];
        self.indicatorView.color = [UIColor blackColor];
        [self addSubview:self.indicatorView];
        [self.indicatorView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.center.equalTo(self);
        }];
        
        self.deleteButton = [GMButton buttonWithType:UIButtonTypeCustom];
        [self addSubview:self.deleteButton];
        [self.deleteButton setImage:[UIImage imageNamed:@"image_delete"] forState:UIControlStateNormal];
        [self.deleteButton addTarget:self action:@selector(deleteAction:) forControlEvents:UIControlEventTouchUpInside];
        [self.deleteButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.mas_top).offset(3);
            make.right.equalTo(self.mas_right).offset(-3);
        }];
        
        self.deleteButton.hidden = YES;
        self.retryButton.hidden = YES;
        self.indicatorView.hidden = YES;
        
        [self setBackgroundImage:_image forState:UIControlStateNormal];
        [self addTarget:self action:@selector(didSelectedAction:) forControlEvents:UIControlEventTouchUpInside];
        
        _dayLabel = [GMLabel labelWithTextAlignment:NSTextAlignmentLeft backgroundColor:[UIColor clearColor] textColor:[UIColor whiteColor] fontSize:10];
        _dayLabel.hidden = YES;
        [self addSubview:_dayLabel];
        [_dayLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(5);
            make.bottom.mas_equalTo(-5);
        }];
        
    }
    return self;
}


- (void)setButtonImageWithUrl:(NSString *)url forState:(UIControlState)state completed:(SDWebImageCompletionBlock)completedBlock{
    [self sd_setBackgroundImageWithURL:[NSURL URLWithString:url] forState:state completed:^(UIImage *image, NSError *error, SDImageCacheType cacheType, NSURL *imageURL) {
        completedBlock(image,error,cacheType,imageURL);
    }];
}


/***  @brief  重新上传图片*/
- (void)retryAction:(UIButton *)button{

    if ([self.delegate respondsToSelector:@selector(prepareRetryUploadPreviewCell:)]) {
        [self.delegate prepareRetryUploadPreviewCell:self];
    }
}
/***  @brief  删除图片*/
- (void)deleteAction:(UIButton *)button{
    if ([self.delegate respondsToSelector:@selector(prepareDeletePreviewCell:)]) {
        [self.delegate prepareDeletePreviewCell:self];
    }
}
/***  @brief  添加/大图浏览图片*/
- (void)didSelectedAction:(UIButton *)sender
{
    if (sender.tag == 1000) {
        //添加图片
        if ([self.delegate respondsToSelector:@selector(prepareAddPreviewCell:)]) {
            [self.delegate prepareAddPreviewCell:self];
        }
    }else{
        //大图模式
        if ([self.delegate respondsToSelector:@selector(didSelectedPreviewCell:)]) {
            [self.delegate didSelectedPreviewCell:self];
        }
    }
}

@end
