//
//  GMScrollView.m
//  Gengmei
//
//  Created by wangyang on 15/12/3.
//  Copyright © 2015年 Wanmeichuangyi. All rights reserved.
//

#import "GMScrollView.h"
#import <Masonry/Masonry.h>

@interface GMScrollView () {
    
}
@end

@implementation GMScrollView
@dynamic contentInset;


- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)awakeFromNib{
    [super awakeFromNib];
    [self setup];
}

- (void)setup{
    
}

- (void)containerAppendSubview:(UIView *)view{
    [self.container addSubview:view];
}

- (void)containerLayoutSubview {
    
    UIView *preView;
    for (NSInteger i = 0; i < self.container.subviews.count ; i ++) {
        UIView *currentView = self.container.subviews[i];
        if (self.layout == GMScrollViewLayoutHorizontal) {
            [currentView mas_makeConstraints:^(MASConstraintMaker *make) {
                if ( i == 0) {
                    make.left.mas_equalTo(0);
                }else{
                    make.left.equalTo(preView.mas_right).offset(self.innerSpace);
                }
                make.top.mas_equalTo(0);
                make.bottom.mas_equalTo(0);
                if (self.itemSize.width != 0) {
                    make.width.mas_equalTo(self.itemSize.width);
                }
                if (self.itemSize.height != 0) {
                    make.height.mas_equalTo(self.itemSize.height);
                }
                if (i == self.container.subviews.count - 1) {
                    make.right.mas_equalTo(0);
                }
            }];
        }else{
            [currentView mas_makeConstraints:^(MASConstraintMaker *make) {
                make.left.mas_equalTo(0);
                make.right.mas_equalTo(0);
                if (self.itemSize.width != 0) {
                    make.width.mas_equalTo(self.itemSize.width);
                }
                if (self.itemSize.height != 0) {
                    make.height.mas_equalTo(self.itemSize.height);
                }
                
                if ( i == 0) {
                    make.top.mas_equalTo(0);
                }else{
                    make.top.equalTo(preView.mas_bottom).offset(self.innerSpace);
                }
                
                if (i == self.container.subviews.count - 1) {
                    make.bottom.mas_equalTo(0);
                }
            }];
        }
        
        currentView.tag = i;
        currentView.userInteractionEnabled = true;
        UITapGestureRecognizer *tapGest = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(itemClicked:)];
        [currentView addGestureRecognizer:tapGest];
        preView = currentView;
    }
}

- (void)itemClicked:(UITapGestureRecognizer *)guester
{
    if (self.itemClickBlock) {
        self.itemClickBlock([guester view].tag);
    }
}

- (void)containerRemoveAllSubviews {
    [self.container.subviews makeObjectsPerformSelector:@selector(removeFromSuperview)];
}

- (UIView *)container{
    if (!_container) {
        _container = [UIView new];
        _container.backgroundColor = [UIColor clearColor];
        [self addSubview:_container];
        [_container mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.insets(UIEdgeInsetsZero);
        }];
    }
    return _container;
}

@end

