//
//  GMBaseTableViewCell.m
//  Gengmei
//
//  Created by 翟国钧 on 15/1/14.
//  Copyright (c) 2015年 Wanmeichuangyi. All rights reserved.
//

#import "GMTableViewCell.h"
#import "UIView+LineWithAutolayout.h"
#import <Masonry/Masonry.h>
#import "GMConstant.h"
#import "GMTheme.h"
@implementation GMTableViewCell

- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self lifeCycle];
    }
    return self;
}

- (void)awakeFromNib{
    [super awakeFromNib];
    [self lifeCycle];
}

- (void)lifeCycle{
    [self setup];

    // 保证在 cell layout 前有“全约束”
    [self cellConstraints];
    [self updateCellConstraints];
}

- (void)setup{

    // 初始一个较大的 bounds，就不会出现在刚刚约束时就出现的 subView 与 contentView 的约束冲突
    self.contentView.bounds = [UIScreen mainScreen].bounds;
    self.selectionStyle = UITableViewCellSelectionStyleNone;
    self.accessoryType = UITableViewCellAccessoryNone;

    _bottomLine = [self.contentView addBottomLine];
    _bottomLine.backgroundColor = BACKGROUND_COLOR;

    _detailDisclosure = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"arrow"]];
    _detailDisclosure.hidden = YES;
    [self.contentView addSubview:_detailDisclosure];
    [_detailDisclosure mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(-15);
        make.centerY.mas_equalTo(0);
        make.size.sizeOffset(CGSizeMake(7, 11));
    }];
}

- (void)prepareForReuse{
    [super prepareForReuse];

    // 在 cell 被复用时，也先设置一个较大的 bounds。因为如果即将 layout 的 subview 超出 contentView时，会发出的约束警告，有了这个 bounds，警告就不会出现了
    self.contentView.bounds = [UIScreen mainScreen].bounds;

}

// 的iOS8下发现不重写这个 seperator 不生效
- (UIEdgeInsets)layoutMargins
{
    return UIEdgeInsetsZero;
}

- (void)setShowArrow:(BOOL)showArrow{
    _showArrow = showArrow;
    _detailDisclosure.hidden = !_showArrow;
}

- (void)cellConstraints{
    
}

- (void)updateCellConstraints{

}
@end
