//
//  GMImageTitleLabelButton.m
//  Gengmei
//
//  Created by wangyang on 15/10/15.
//  Copyright © 2015年 Wanmeichuangyi. All rights reserved.
//

#import "GMVerticalLayoutButton.h"
#import "GMFont.h"
#import <Masonry/Masonry.h>
#import "GMTheme.h"
@implementation GMVerticalLayoutButton

- (void)setup{
    [super setup];
    
    _buttonLabel = [UILabel new];
    _buttonLabel.font = GMFont(10);
    _buttonLabel.textColor = BODY_TEXT_COLOR;
    [self addSubview:_buttonLabel];
    
    _buttonImageView = [UIImageView new];
    [self addSubview:_buttonImageView];
    
    [self setBackgroundColor:RGBCOLOR_HEX(0xfafafa) forState:UIControlStateHighlighted];
    [self setBackgroundColor:[UIColor whiteColor] forState:UIControlStateNormal];
}

- (void)updateConstraints{
    [self.buttonLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(-10);
        make.centerX.mas_equalTo(0);
    }];
    
    [self.buttonImageView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(10);
        make.centerX.mas_equalTo(0);
    }];
    [super updateConstraints];
}

@end
