//
//  GMConstant.h
//  Gengmei
//
//  Created by licong on 15/12/31.
//  Copyright © 2015年 Wanmeichuangyi. All rights reserved.
//

#ifndef GMConstant_h
#define GMConstant_h


//设备屏幕大小
#define  MAINSCREEN_FRAME  [[UIScreen mainScreen] bounds]

//设备屏幕宽
#define  MAINSCREEN_WIDTH  MAINSCREEN_FRAME.size.width

//设备屏幕高
#define  MAINSCREEN_HEIGHT MAINSCREEN_FRAME.size.height

#define  ONE_PIXEL       (1/[UIScreen mainScreen].scale)

//获取NSUserdefault
#define USERDEFAULT    [NSUserDefaults standardUserDefaults]

//分页每一页的数据数量
#define PAGE_COUNT      10


// version check
#define SYSTEM_VERSION_EQUAL_TO(v)                  ([[[UIDevice currentDevice] systemVersion] compare:v options:       NSNumericSearch] == NSOrderedSame)
#define SYSTEM_VERSION_GREATER_THAN(v)              ([[[UIDevice currentDevice] systemVersion] compare:v options:       NSNumericSearch] == NSOrderedDescending)
#define SYSTEM_VERSION_GREATER_THAN_OR_EQUAL_TO(v)  ([[[UIDevice currentDevice] systemVersion] compare:v options:       NSNumericSearch] != NSOrderedAscending)
#define SYSTEM_VERSION_LESS_THAN(v)                 ([[[UIDevice currentDevice] systemVersion] compare:v options:       NSNumericSearch] == NSOrderedAscending)
#define SYSTEM_VERSION_LESS_THAN_OR_EQUAL_TO(v)     ([[[UIDevice currentDevice] systemVersion] compare:v options:       NSNumericSearch] != NSOrderedDescending)


//沙盒目录
#define PATH_OF_APP_HOME    NSHomeDirectory()
#define PATH_OF_TEMP        NSTemporaryDirectory()
#define PATH_OF_BUNDLE      [NSBundle mainBundle].resourcePath
#define PATH_OF_DOCUMENT    [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) objectAtIndex:0]

//App版本
#define APP_VERSION                         [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleShortVersionString"]
#define APP_BUILD_VERSION                   [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleVersion"]


#endif /* GMConstant_h */
