//
//  GMTheme.h
//  Gengmei
//  主题
//  Created by Thierry on 1/7/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#ifndef Gengmei_GMTheme_h
#define Gengmei_GMTheme_h

#define RGBCOLOR_HEX(hexColor) [UIColor colorWithRed: (((hexColor >> 16) & 0xFF))/255.0f         \
green: (((hexColor >> 8) & 0xFF))/255.0f             \
blue: ((hexColor & 0xFF))/255.0f                    \
alpha: 1]


//用户版色值
#ifdef IS_USER

//颜色规范
#define MAIN_VISUAL_COLOR                       RGBCOLOR_HEX(0x3ADBD2) //主视觉颜色
#define SECONDARY_VISUAL_COLOR                  RGBCOLOR_HEX(0xFF7690) //辅助颜色
#define MAIN_TIP_COLOR                          RGBCOLOR_HEX(0x9D704F) //提示文字主色（黄背景）
#define SECONDARY_TIP_COLOR                     RGBCOLOR_HEX(0xC19474)//提示文字辅助色（黄背景）
#define DISABLE_COLOR                           RGBCOLOR_HEX(0xD5D5D5) //失效颜色
#define SEPARATOR_LINE_COLOR                    RGBCOLOR_HEX(0xE5E5E5) //分割线颜色、边框颜色
#define BACKGROUND_COLOR                        RGBCOLOR_HEX(0xF5F5F5) //背景颜色
#define BACKGROUND_TIP_COLOR                    RGBCOLOR_HEX(0xF8F4DD) //提示背景颜色(黄)
#define BLACK_COLOR                             RGBCOLOR_HEX(0x000000) //纯黑颜色
#define WHITE_COLOR                             RGBCOLOR_HEX(0xFFFFFF) //纯白颜色

//文字颜色
#define HEADLINE_TEXT_COLOR                     RGBCOLOR_HEX(0x333333) //一级标题字、主要内容
#define BODY_TEXT_COLOR                         RGBCOLOR_HEX(0x666666) //正文、普通文字内容
#define SECONDARY_TEXT_COLOR                    RGBCOLOR_HEX(0x999999) //辅助文字色

//按钮颜色
#define BUTTON_NOMARL_GREEN_COLOR               RGBCOLOR_HEX(0x3ADBD2) //目前和MAIN_VISUAL_COLOR一样
#define BUTTON_HIGHLIGHT_GREEN_COLOR            RGBCOLOR_HEX(0x1FB2A7)
#define BUTTON_NOMARL_RED_COLOR                 RGBCOLOR_HEX(0xFF7690) //目前和SECONDARY_VISUAL_COLOR一样
#define BUTTON_HIGHLIGHT_RED_COLOR              RGBCOLOR_HEX(0xE75873)
#define BUTTON_DISABLE_COLOR                    RGBCOLOR_HEX(0xD5D5D5) //目前和DISABLE_COLOR一样



//医生版色值，目前未支持
#elif IS_DOCTOR


//颜色规范


/* 医生版主视觉颜色,暂时改为红色，用来区分 */ 
#define MAIN_VISUAL_COLOR                       RGBCOLOR_HEX(0x3ADBD2) //医生版主视觉颜色,暂时改为红色，用来区分
#define SECONDARY_VISUAL_COLOR                  RGBCOLOR_HEX(0xFF7690) //医生版辅助颜色
#define MAIN_TIP_COLOR                          RGBCOLOR_HEX(0x9D704F) //医生版提示文字主色（黄背景）
#define SECONDARY_TIP_COLOR                     RGBCOLOR_HEX(0xC19474) //医生版提示文字辅助色（黄背景）
#define DISABLE_COLOR                           RGBCOLOR_HEX(0xD5D5D5) //医生版失效颜色
#define SEPARATOR_LINE_COLOR                    RGBCOLOR_HEX(0xE5E5E5) //医生版分割线颜色、边框颜色
#define BACKGROUND_COLOR                        RGBCOLOR_HEX(0xF5F5F5) //医生版背景颜色
#define BACKGROUND_TIP_COLOR                    RGBCOLOR_HEX(0xF8F4DD) //医生版提示背景颜色(黄)
#define BLACK_COLOR                             RGBCOLOR_HEX(0x000000) //医生版纯黑颜色
#define WHITE_COLOR                             RGBCOLOR_HEX(0xFFFFFF) //医生版纯白颜色

//文字颜色
#define HEADLINE_TEXT_COLOR                     RGBCOLOR_HEX(0x333333) //医生版一级标题字、主要内容
#define BODY_TEXT_COLOR                         RGBCOLOR_HEX(0x666666) //医生版正文、普通文字内容
#define SECONDARY_TEXT_COLOR                    RGBCOLOR_HEX(0x999999) //医生版辅助文字色

//按钮颜色
#define BUTTON_NOMARL_GREEN_COLOR               RGBCOLOR_HEX(0x3ADBD2) //目前和MAIN_VISUAL_COLOR一样
#define BUTTON_HIGHLIGHT_GREEN_COLOR            RGBCOLOR_HEX(0x1FB2A7)
#define BUTTON_NOMARL_RED_COLOR                 RGBCOLOR_HEX(0xFF7690) //目前和SECONDARY_VISUAL_COLOR一样
#define BUTTON_HIGHLIGHT_RED_COLOR              RGBCOLOR_HEX(0xE75873)
#define BUTTON_DISABLE_COLOR                    RGBCOLOR_HEX(0xD5D5D5) //目前和DISABLE_COLOR一样






#else  //这里的默认色值可以随意,默认填的是用户板的色值



//颜色规范
#define MAIN_VISUAL_COLOR                       RGBCOLOR_HEX(0x3ADBD2)
#define SECONDARY_VISUAL_COLOR                  RGBCOLOR_HEX(0xFF7690) //默认辅助颜色
#define MAIN_TIP_COLOR                          RGBCOLOR_HEX(0x9D704F) //默认提示文字主色（黄背景）
#define SECONDARY_TIP_COLOR                     RGBCOLOR_HEX(0xC19474) //默认提示文字辅助色（黄背景）
#define DISABLE_COLOR                           RGBCOLOR_HEX(0xD5D5D5) //默认失效颜色
#define SEPARATOR_LINE_COLOR                    RGBCOLOR_HEX(0xE5E5E5) //默认分割线颜色、边框颜色
#define BACKGROUND_COLOR                        RGBCOLOR_HEX(0xF5F5F5) //默认背景颜色
#define BACKGROUND_TIP_COLOR                    RGBCOLOR_HEX(0xF8F4DD) //默认提示背景颜色(黄)
#define BLACK_COLOR                             RGBCOLOR_HEX(0x000000) //默认纯黑颜色
#define WHITE_COLOR                             RGBCOLOR_HEX(0xFFFFFF) //默认纯白颜色

//文字颜色
#define HEADLINE_TEXT_COLOR                     RGBCOLOR_HEX(0x333333) //默认一级标题字、主要内容
#define BODY_TEXT_COLOR                         RGBCOLOR_HEX(0x666666) //默认正文、普通文字内容
#define SECONDARY_TEXT_COLOR                    RGBCOLOR_HEX(0x999999) //默认辅助文字色

//按钮颜色
#define BUTTON_NOMARL_GREEN_COLOR               RGBCOLOR_HEX(0x3ADBD2) //目前和MAIN_VISUAL_COLOR一样
#define BUTTON_HIGHLIGHT_GREEN_COLOR            RGBCOLOR_HEX(0x1FB2A7)
#define BUTTON_NOMARL_RED_COLOR                 RGBCOLOR_HEX(0xFF7690) //目前和SECONDARY_VISUAL_COLOR一样
#define BUTTON_HIGHLIGHT_RED_COLOR              RGBCOLOR_HEX(0xE75873)
#define BUTTON_DISABLE_COLOR                    RGBCOLOR_HEX(0xD5D5D5) //目前和DISABLE_COLOR一样




#endif

#endif
