//
//  CacheService.m
//  Gengmei
//
//  Created by Thierry on 1/5/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "WMCacheService.h"
#import "WMDocumentCache.h"

static WMCacheService *sharedManager = nil;

@implementation WMCacheService

+ (instancetype)sharedInstance{
    static dispatch_once_t oncePredicate;
    dispatch_once(&oncePredicate,^{
        sharedManager = [[WMCacheService alloc]init];
    });
    return sharedManager;
    
}

- (void)storeObjectAtDiskWithkey:(NSString *)key object:(id <NSCoding>)object block:(TMDiskCacheObjectBlock)block{
    [[TMCache sharedCache].diskCache setObject:object forKey:key block:block];
}

- (void)fetchObjectAtDiskWithkey:(NSString *)key block:(TMDiskCacheObjectBlock)block{
    [[TMCache sharedCache].diskCache objectForKey:key block:block];
}

- (void)removeObjectAtDiskWithkey:(NSString *)key block:(TMDiskCacheObjectBlock)block{
    [[TMCache sharedCache].diskCache removeObjectForKey:key block:block];
}

- (void)removeAllObjectsAtDiskWithBlock:(TMDiskCacheBlock)block{
    [[TMCache sharedCache].diskCache removeAllObjects:block];
}


- (void)storeObjectAtDiskWithkey:(NSString *)key object:(id <NSCoding>)object{
    [[TMCache sharedCache].diskCache setObject:object forKey:key];

}
- (id)fetchObjectAtDiskWithkey:(NSString *)key{
   return  [[TMCache sharedCache].diskCache objectForKey:key];
}
- (void)removeObjectAtDiskWithkey:(NSString *)key{
    [[TMCache sharedCache].diskCache removeObjectForKey:key];
    
}
- (void)removeAllObjectsAtDisk{
    [[TMCache sharedCache].diskCache removeAllObjects];
}


- (void)storeObjectAtMemoryWithkey:(NSString *)key object:(id <NSCoding>)object block:(TMMemoryCacheObjectBlock)block{
    [[TMCache sharedCache].memoryCache setObject:object forKey:key block:block];
}
- (void)fetchObjectAtMemoryWithkey:(NSString *)key block:(TMMemoryCacheObjectBlock)block{
    [[TMCache sharedCache].memoryCache objectForKey:key block:block];
}
- (void)removeObjectAtMemoryWithkey:(NSString *)key block:(TMMemoryCacheObjectBlock)block{
    [[TMCache sharedCache].memoryCache removeObjectForKey:key block:block];

}
- (void)removeAllObjectsAtMemoryWithBlock:(TMMemoryCacheBlock)block{
    [[TMCache sharedCache].memoryCache removeAllObjects:block];
}


- (void)storeObjectAtMemoryWithkey:(NSString *)key object:(id)object{
    [[TMCache sharedCache].memoryCache setObject:object forKey:key];
}
- (id)fetchObjectAtMemoryWithkey:(NSString *)key{
    return  [[TMCache sharedCache].memoryCache objectForKey:key];
}
- (void)removeObjectAtMemoryWithkey:(NSString *)key{
    [[TMCache sharedCache].memoryCache removeObjectForKey:key];
}
- (void)removeAllObjectsAtMemory{
    [[TMCache sharedCache].memoryCache removeAllObjects];
}



- (void)storeObjectAtDucmentPathWithkey:(NSString *)key
                                 object:(id <NSCoding>)object
                                  block:(TMDiskCacheObjectBlock)block{
    [[WMDocumentCache sharedCache].diskCache setObject:object forKey:key block:block];
}
- (void)fetchObjectAtDucmentPathWithkey:(NSString *)key
                                  block:(TMDiskCacheObjectBlock)block{
    [[WMDocumentCache sharedCache].diskCache objectForKey:key block:block];
}
- (void)removeObjectAtDucmentPathWithkey:(NSString *)key
                                   block:(TMDiskCacheObjectBlock)block{
    [[WMDocumentCache sharedCache].diskCache removeObjectForKey:key block:block];
}
- (void)removeAllObjectsAtDucmentPathWithBlock:(TMDiskCacheBlock)block{
    [[WMDocumentCache sharedCache].diskCache removeAllObjects:block];
}

- (void)storeObjectAtDucmentPathWithkey:(NSString *)key
                                 object:(id <NSCoding>)object{
    [[WMDocumentCache sharedCache].diskCache setObject:object forKey:key];
}
- (id)fetchObjectAtDucmentPathWithkey:(NSString *)key{
   return  [[WMDocumentCache sharedCache].diskCache objectForKey:key];
}
- (void)removeObjectAtDucmentPathWithkey:(NSString *)key{
    [[WMDocumentCache sharedCache].diskCache removeObjectForKey:key];
}
- (void)removeAllObjectsAtDucmentPath{
    [[WMDocumentCache sharedCache].diskCache removeAllObjects];
}

@end
