//
//  GMViewController.m
//  GMPhobos
//
//  Created by licong on 01/27/2016.
//  Copyright (c) 2016 licong. All rights reserved.
//

#import "GMViewController.h"
#import <GMPhobos/Phobos.h>
#import <GMCache/GMCache.h>
#import "GMPhobos_Example-Swift.h"

//@import GMCache;
@import GMPhobos.PhobosUtil;
@import GMPhobos.Phobos;
#define PhobosCacheKey @"PhobosCacheKey"

NSString      *const MockAppName      = @"gengmei_test";
NSString      *const MockChannelId    = @"AppStore";
NSString      *const MockEventId      = @"eventId";
NSString      *const MockUserId       = @"1";
NSString      *const MockCityId       = @"beijing";

@interface GMViewController ()

@end

@implementation GMViewController

- (void)viewDidLoad
{
    [super viewDidLoad];

#ifdef POD_CONFIGURATION_APP_STORE
    NSString *url = @"http://log.gmei.com/log/collect";
#else
    NSString *url = @"http://log.test.igengmei.com/log/collect";
#endif
    [[NSUserDefaults standardUserDefaults] setBool:YES forKey:PhobosGray];
    Phobos *client = [Phobos clientWithAppName:MockAppName channelId:MockChannelId];
    [Phobos setSharedClient:client];
    Phobos.sharedClient.serverAPI = url;
    [Phobos.sharedClient setLogEnabled:NO]; // 调试打Log模式，看情况开启
    Phobos.sharedClient.signingType = PhobosSigningTypeDebug;
    Phobos.sharedClient.userId = @"";
    Phobos.sharedClient.getTopController = ^UIViewController * _Nonnull{
        return self;
    };
    
    NSString *inDate = [PhobosUtil currentTime];
    NSMutableDictionary *dict = [[NSMutableDictionary alloc] init];
    [dict setObject:[PhobosUtil currentTime] forKey:@"out"];
    [dict setObject:inDate forKey:@"in"];
    [dict setObject:@"test" forKey:@"page_name"];
    [dict setObject:@"" forKey:@"business_id"];
    [dict setObject:@"" forKey:@"referrer"];
    [dict setObject:@(0) forKey:@"fake"];
    [dict setObject:@"" forKey:@"referrer_id"];
    [dict setObject:@"" forKey:@"extra_param"];
    [dict setObject:@"" forKey:@"referrer_tab_name"];
    [dict setObject:@(0) forKey:@"is_push"];
//    [Phobos track:@"page_view" attributes:dict];
//    NSArray *array = [GMCache fetchObjectAtDocumentPathWithkey:PhobosCacheKey];
//
//    [Phobos track:@"page_view" attributes:dict];
//    array = [GMCache fetchObjectAtDocumentPathWithkey:PhobosCacheKey];
    
    [dict setObject:[PhobosUtil currentTime] forKey:@"in"];
    [dict setObject:[PhobosUtil currentTime] forKey:@"out"];
    [Phobos track:@"page_view" attributes:dict sendNow:YES];
//    array = [GMCache fetchObjectAtDocumentPathWithkey:PhobosCacheKey];
    
    [Phobos track:@"test" attributes:dict sendNow:YES];
    [Phobos track:@"test2" attributes:dict sendNow:YES];
    [Phobos track:@"test3" attributes:dict sendNow:YES];
    [Phobos track:@"test4" attributes:dict sendNow:YES];
    [Phobos track:@"test5" attributes:dict sendNow:YES];
    [Phobos track:@"test6" attributes:dict sendNow:YES];
    [Phobos track:@"test7" attributes:dict sendNow:YES];
    [Phobos track:@"test8" attributes:dict sendNow:YES];
//    array = [GMCache fetchObjectAtDocumentPathWithkey:PhobosCacheKey];
}

- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event {
    swiftVC *vc = [swiftVC new];
    [self presentViewController:vc animated:YES completion:nil];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
